function [nodeLabels] = UGM_Decode_LBP(nodePot,edgePot,edgeStruct,logspace)
% NODELABELS = UGM_DECODE_LBP(NODEPOT, EDGEPOT, EDGESTRUCT, LOGSPACE)
%   Computes (approximate) MAP estimate using Max-Product or Max-Sum
%   variant of Loopy Belief Propagation.  Updates are performed in
%   log-domain if LOGSPACE=1 (a.k.a Max-Sum) on log-potentials NODEPOT and
%   EDGEPOT, otherwise if LOGSPACE=0 Max-Product updates are performed on
%   model potentials (e.g. NODEPOT and EDGEPOT are not log-potentials).  
%
%   NODELABLES is the (approximate) MAP configuration.
%
% Initial Implementation: M. Schmidt
%
% 2014: J. Pacheco
% Max-Sum updates added.
%

if edgeStruct.useMex
  if logspace, error('UGM_Decode_LBP: Max-sum not yet implemented in Mex.  Set LOGSPACE=0.');  end
	nodeBel = UGM_Decode_LBPC(nodePot,edgePot,edgeStruct.edgeEnds,edgeStruct.nStates,edgeStruct.V,edgeStruct.E,int32(edgeStruct.maxIter));
else
  
  % accumulation operators
  if logspace
    opFun = @plus;     
    opFunInv = @minus;
    opNorm = @logsumexp;
  else     
    opFun = @times;
    opFunInv = @rdivide;
    opNorm = @sum;
  end
  
  % Run LBP
	maximize = 1;
	[new_msg, converged] = UGM_LoopyBP(nodePot,edgePot,edgeStruct,maximize,logspace);
  if ~converged, fprintf('Loopy did not converge\n');  end
	
  % Init stuff
	[nNodes,maxState] = size(nodePot);
	nEdges = size(edgePot,3);
	edgeEnds = edgeStruct.edgeEnds;
	V = edgeStruct.V;
	E = edgeStruct.E;
	nStates = edgeStruct.nStates;
	
	% Compute node beliefs
	for n = 1:nNodes
		edges = E(V(n):V(n+1)-1);
		prod_of_msgs(1:nStates(n),n) = nodePot(n,1:nStates(n))';
    for e = edges(:)'
      if n == edgeEnds(e,2)
        prod_of_msgs(1:nStates(n),n) = opFun(prod_of_msgs(1:nStates(n),n), new_msg(1:nStates(n),e));
      else
        prod_of_msgs(1:nStates(n),n) = opFun(prod_of_msgs(1:nStates(n),n), new_msg(1:nStates(n),e+nEdges));
      end
    end
    
    % Normalize
    norm_const = opNorm( prod_of_msgs(1:nStates(n),n) );
		nodeBel(n,1:nStates(n)) = opFunInv(prod_of_msgs(1:nStates(n),n)', norm_const);
	end
end

% MAP estimate (assumes no ties)
[pot nodeLabels] = max(nodeBel,[],2);
