function  [nodeLabels, messages] = UGM_Decode_Tree(nodePot, edgePot, edgeStruct, logspace)
% INPUT
% nodePot(node,class)
% edgePot(class,class,edge) where e is referenced by V,E (must be the same
% between feature engine and inference engine)
%
% OUTPUT
% nodeBel(node,class) - marginal beliefs
% edgeBel(class,class,e) - pairwise beliefs
% logZ - negative of free energy
%
% Assumes no ties

  [nNodes,maxState] = size(nodePot);
  edgeEnds = edgeStruct.edgeEnds;
  nEdges = size( edgeEnds, 1 );
  nStates = edgeStruct.nStates;
  V = edgeStruct.V;
  E = edgeStruct.E;

  % accumulation operators
  if logspace
    opFun = @plus;     
    opFunInv = @minus;
    opNorm = @logsumexp;
  else     
    opFun = @times;
    opFunInv = @rdivide;
    opNorm = @sum;
  end

  % Compute Messages
  maximize = 1;
  messages = UGM_TreeBP(nodePot,edgePot,edgeStruct,maximize,logspace);

  % Compute nodeBel
  for n = 1:nNodes
    nodeBel(n,1:nStates(n)) = nodePot(n,1:nStates(n));
    
    edges = E(V(n):V(n+1)-1);
    for e = edges(:)'
      if n == edgeEnds(e,2)
        nodeBel(n,1:nStates(n)) = opFun(nodeBel(n,1:nStates(n)),messages(1:nStates(n),e)');
      else
        nodeBel(n,1:nStates(n)) = opFun(nodeBel(n,1:nStates(n)),messages(1:nStates(n),e+nEdges)');
      end
    end
    
    % normalize
    norm_const = opNorm( nodeBel(n,1:nStates(n)) );
    nodeBel(n,1:nStates(n)) = opFunInv( nodeBel(n,1:nStates(n)), norm_const );
  end

  [pot nodeLabels] = max(nodeBel,[],2);
end
