% example_UGM_DemoHCRF.m
% 
% This is a demo script that:
% - loads some example synthetic generated by 
%   three HMMs with 4 hidden states each. Two of the hidden states are the
%   same for all HMMs. The result is data generated by a total of 6 hidden 
%   states for 3 classes.
% - trains an HCRF model with 3 labels and 6 hidden states
% - tests the trained model with the test dataset
%
% HCRF paper: Quattoni et al. Hidden Conditional Random Fields, TPAMI 2007
%
% Author: Konstantinos Bousmalis 2013 - www.doc.ic.ac.uk/~kb709


% set the script
load data.mat;
seed = 200;
nStates = 6;
lambdaVal = 0;

s = RandStream.create('mt19937ar','seed',seed);
RandStream.setGlobalStream(s);

nLabels = max(trainData.labels);
nXFeats = size(trainData.data{1},1);
edgeStruct = UGM_HCRF_makeEdgeStruct([],nStates,1);
nInstances = length(trainData.labels);
Xnode = cell(1,nInstances);
y=zeros(1,length(trainData.labels));
for instance = 1:nInstances
    Xnode{instance} = trainData.data{instance}';
    y(instance)     = trainData.labels(instance);
end
nodeMap = zeros(nStates, nXFeats,'int32');
featNo = 1;
for s = 1:nStates
    for f = 1:nXFeats
        nodeMap(s, f) = featNo;
        featNo = featNo + 1;
    end    
end
edgeMap = zeros(nStates, nStates, nLabels, 'int32');
for s1 = 1:nStates
    for s2 = 1:nStates
        for l = 1:nLabels
            edgeMap(s1, s2, l) = featNo;
            featNo = featNo + 1;
        end
    end
end        
labelMap = zeros(nStates, nLabels, 'int32');
for s = 1:nStates
    for l = 1:nLabels
        labelMap(s, l) = featNo;
        featNo = featNo + 1;
    end
end
nParams = featNo-1;


Xedge = ones(nStates, nStates, nLabels);

w = rand(nParams, 1);
edgeStruct.nStates = nStates;
edgeStruct.nLabels = nLabels;
edgeStruct.useMex  = 0;


% Set up regularization parameters
lambda = lambdaVal*ones(size(w));
reglaFunObj = @(w)penalizedL2(w,@UGM_HCRF_NLL,lambda,Xnode,Xedge,y,nodeMap, edgeMap, labelMap, edgeStruct,@UGM_Infer_logChain);

% LBFGS to find the weights
display('Training...');
options.LS=0;
options.TolFun=1e-2;
options.TolX=1e-2;
options.Method='lbfgs';
options.Display='on';
options.MaxIter=400;
options.DerivativeCheck='off';
w = minFunc(reglaFunObj,w, options);


display('Testing on 300 test sequences...');
test=testData.data;

for i = 1:length(test)    
    Xnode={test{i}'};
    for Y=1:nLabels
        NLL(i,Y) = UGM_HCRF_NLL(w,Xnode,Xedge,Y,nodeMap, edgeMap, labelMap, edgeStruct,@UGM_Infer_logChain);
    end
end

[a, predictedLabels]=min(NLL,[],2);
acc = numel(find(int32(predictedLabels)-int32(testData.labels)'==0))/numel(int32(testData.labels));

display(sprintf('The accuracy is %d%%', acc*100));


