function [nodeBel, edgeBel, logZ, messages, iters] = UGM_Infer_LBP(nodePot,edgePot,edgeStruct,stepsize,maximize,logspace)

  if edgeStruct.useMex      
      [nodeBel,edgeBel,logZ, messages, iters] = UGM_Infer_LBPC(nodePot,edgePot,...
        int32(edgeStruct.edgeEnds),int32(edgeStruct.nStates),int32(edgeStruct.V),...
        int32(edgeStruct.E),int32(edgeStruct.maxIter),stepsize,logical(maximize),logical(logspace));
  else
      [nodeBel, edgeBel, logZ, messages, iters] = Infer_LBP(nodePot,edgePot,edgeStruct,stepsize,maximize,logspace);
  end

end

function [nodeBel, edgeBel, logZ, new_msg, iters] = Infer_LBP(nodePot,edgePot,edgeStruct,stepsize,maximize,logspace)


  % Init. stuff
  [nNodes,maxState] = size(nodePot);
  nEdges = size(edgePot,3);
  edgeEnds = edgeStruct.edgeEnds;
  V = edgeStruct.V;
  E = edgeStruct.E;
  nStates = edgeStruct.nStates;
  
%   % DEBUG: force logspace for maximization
%   forcedlog = 0;
%   if maximize && ~logspace
%     nodePot = log( nodePot );
%     edgePot = log( edgePot );
%     logspace = 1;
%     forcedlog = 1;
%   end
  
  % Run Loopy BP
  [new_msg, iters] = UGM_LoopyBP(nodePot,edgePot,edgeStruct,stepsize,maximize,logspace);  
  
%   % DEBUG: undo forced logspace
%   if forcedlog
%     new_msg = exp( new_msg );
%     logspace = 0;    
%   end
  
  % accumulation operators
  if logspace
    opFun = @plus;     
    opFunInv = @minus;
    opNorm = @logsumexp;
  else     
    opFun = @times;
    opFunInv = @rdivide;
    opNorm = @sum;
  end

  % Compute node beliefs
  nodeBel = zeros(nNodes, maxState);
	for n = 1:nNodes
		edges = E(V(n):V(n+1)-1);
		prod_of_msgs(1:nStates(n),n) = nodePot(n,1:nStates(n))';
    for e = edges(:)'
      if n == edgeEnds(e,2)
        prod_of_msgs(1:nStates(n),n) = opFun(prod_of_msgs(1:nStates(n),n), new_msg(1:nStates(n),e));
      else
        prod_of_msgs(1:nStates(n),n) = opFun(prod_of_msgs(1:nStates(n),n), new_msg(1:nStates(n),e+nEdges));
      end
    end
    
    % Normalize
    norm_const = opNorm( prod_of_msgs(1:nStates(n),n) );
		nodeBel(n,1:nStates(n)) = opFunInv(prod_of_msgs(1:nStates(n),n)', norm_const);
  end  
  
  % Do the right thing for divide by zero
  msg_tmp = new_msg;
  if ~logspace
    msg_tmp(msg_tmp==0) = inf;
  end
  
  % Compute edge beliefs  
  if nargout > 1   
     edgeBel = zeros(maxState,maxState,nEdges);
     for e = 1:nEdges
        n1 = edgeEnds(e,1);
        n2 = edgeEnds(e,2);

        % construct product(sum) of incoming messages by removing 
        % messages between n1 & n2 from node beliefs
        belN1 = opFunInv(nodeBel(n1,1:nStates(n1))',msg_tmp(1:nStates(n1),e+nEdges));
        belN2 = opFunInv(nodeBel(n2,1:nStates(n2))',msg_tmp(1:nStates(n2),e));

        % combine aggregate messages with edge potential
        b_unary = bsxfun(opFun, belN1, belN2');
        eb = opFun(...
          b_unary, edgePot(1:nStates(n1),1:nStates(n2),e) ...
        );

        % normalize
        norm_const = opNorm(eb(:));
        edgeBel(1:nStates(n1),1:nStates(n2),e) = opFunInv(eb, norm_const);        
     end
  end

  if nargout > 2
     % Compute Bethe free energy 
     % (Z could also be computed as normalizing constant for any node in the tree
     %    if unnormalized messages are used)
     Energy1 = 0; Energy2 = 0; Entropy1 = 0; Entropy2 = 0;

     % log-beliefs?
     if logspace
        nodeBelTmp = exp( nodeBel ) + eps;
        edgeBelTmp = exp( edgeBel ) + eps;
        nodePotTmp = exp( nodePot );
        edgePotTmp = exp( edgePot );
     else     
        nodeBelTmp = nodeBel+eps;
        edgeBelTmp = edgeBel+eps;
        nodePotTmp = nodePot;
        edgePotTmp = edgePot;
     end

     % compute unary terms
     for n = 1:nNodes
        edges = E(V(n):V(n+1)-1);
        nNbrs = length(edges);

        % Node Entropy (can get divide by zero if beliefs at 0)
        Entropy1 = Entropy1 + (nNbrs-1)*sum(nodeBelTmp(n,1:nStates(n)).*log(nodeBelTmp(n,1:nStates(n))));      

        % Node Energy
        Energy1 = Energy1 - sum(nodeBelTmp(n,1:nStates(n)).*log(nodePotTmp(n,1:nStates(n))));
     end

     % compute pairwise terms
     for e = 1:nEdges
        n1 = edgeEnds(e,1);
        n2 = edgeEnds(e,2);

        % Pairwise Entropy (can get divide by zero if beliefs at 0)
        eb = edgeBelTmp(1:nStates(n1),1:nStates(n2),e); % this is slow...
        Entropy2 = Entropy2 - sum(eb(:).*log(eb(:)));

        % Pairwise Energy
        ep = edgePotTmp(1:nStates(n1),1:nStates(n2),e);  
        Energy2 = Energy2 - sum(eb(:).*log(ep(:)));
     end
     F = (Energy1+Energy2) - (Entropy1+Entropy2);
     logZ = -F;
  end
end