function [alpha,kappa,mxState] = UGM_ChainFwd(nodePot,edgePot,nStates,maximize,logspace)

% init stuff.
[nNodes,maxState] = size(nodePot);
mxState = zeros(nNodes,maxState);
alpha = zeros(nNodes,maxState);
alpha(1,1:nStates(1)) = nodePot(1,1:nStates(1));
kappa = zeros(1,nNodes);

% accumulation operator
if logspace
  opFun = @plus;     
else     
  opFun = @times;
end

% compute partition func.
if logspace
  kappa(1) = logsumexp(alpha(1,1:nStates(1)));
  alpha(1,1:nStates(1)) = alpha(1,1:nStates(1)) - kappa(1);
else
  kappa(1) = sum(alpha(1,1:nStates(1)));
  alpha(1,1:nStates(1)) = alpha(1,1:nStates(1))/kappa(1);
end

% forward decoding
for n = 2:nNodes
   tmp = bsxfun(opFun,alpha(n-1,1:nStates(n-1))',edgePot(1:nStates(n-1),1:nStates(n),n-1));   
   
   % max-product / max-sum
   if maximize  
      alpha(n,1:nStates(n)) = bsxfun(opFun, nodePot(n,1:nStates(n)), max(tmp));
      [~, mxState(n,1:nStates(n))] = max(tmp);
   % BP log-domain
   elseif logspace 
      alpha(n,1:nStates(n)) = nodePot(n,1:nStates(n)) + logsumexp(tmp,1);
   % BP probability domain
   else 
      alpha(n,1:nStates(n)) = nodePot(n,1:nStates(n)).*sum(tmp);
   end
   
   % Normalize Message
   if logspace
      kappa(n) = logsumexp(alpha(n,1:nStates(n)));
      alpha(n,1:nStates(n)) = alpha(n,1:nStates(n)) - kappa(n);
   else
      kappa(n) = sum(alpha(n,1:nStates(n)));
      alpha(n,1:nStates(n)) = alpha(n,1:nStates(n))/kappa(n);
   end   
end