Author: Samuel Ainsworth, 2015
Edited by: Jason Pacheco, 2015

===============================
D-PMP: A Smooth Introduction
===============================

This code provides a gentle introduction to using D-PMP for a
nonlinear time series model, given in Example 1 of:

Cappé, Olivier, Simon J. Godsill, and Eric Moulines. "An overview of
  existing methods and recent advances in sequential Monte Carlo."
  Proceedings of the IEEE 95.5 (2007): 899-924.

To run D-PMP we'll need the following:

 1. An initial set of particles. 
 2. A set of proposal functions. 
 3. A function to evaluate log potentials for a given set of particles. 

In our case we:

 1. initialize with particles sampled from the prior
 2. propose new particles based on the transition dynamics of the model
 3. create a function to evaluate the log-potentials

Function handles to each of these pieces are passed to D-PMP.
Inference is run for a fixed number of iterations and the results are
stored to disk.

Since this model is one-dimensional we perform exact MAP inference
over a dense discretization of the state space. The D-PMP estimate
should converge to the "true" dense MAP estimate (*not* the actual
latent state). This provides a convenient way to assess the
convergence of D-PMP. Of course, you'll probably want to apply D-PMP
to problems which don't admit a dense discretization.

The example code is laid out as follows:

 - `demo_smooth_ex.m` This is the most exciting part. Run this script to see all
the flashing lights and pretty pictures. This script is thoroughly documented so
you are encouraged to investigate it in addition to this README.
 - `ssm_init_prior.m` generates an initial set of particles by sample from the
prior.
 - `ssm_fwd_proposal.m` proposes new particles for D-PMP by applying the
transition dynamics.
 - `ssm_eval_model.m` takes a time series model and a particle set and evaluates
all of the unary and pairwise potentials.
 - `ex_model.m` builds a struct that represents the time series model. It has
function handles for sampling from each of the transition and likelihood
distributions, etc.
 - `ssm_sample_model.m` generates a sample from the model built with
`ex_model.m` (or any other such times series model).
 - `ssm_log_prob.m` evaluates the log probability of a given sequence for a time
series model.
 - `ssm1d_dense_map.m` MAP inference over a dense discretization.
 - `ex_callback.m` plots the D-PMP particles and MAP estimate after every
iteration.
 - `DPMP_smooth.m` just takes all of these ingredients and hands them off to
`DPMP_Infer.m` which does the heavy lifting.

If you have any questions / concerns about this example code, send an
angry email to samuel_ainsworth@brown.edu or jason_pacheco@brown.edu

