function stats = ex_callback(x, x_true, xDense, xDenseMap, nodeBelDense, xMAPlabel, y, edgeStruct, stats, dummy)
% ex_callback Callback function for D-PMP smoothing example
%
%   Plots
%     - the max-marginal densities from the dense discretization,
%     - the true latent states `x_{1:T}`,
%     - the dense MAP estimate,
%     - the D-PMP MAP estimate, and
%     - the D-PMP particles at each node.
%
%   Also updates the `stats` struct with the L1err at each iteration.


  T = size(x, 3);
  x_pred = DPMP_getLabelParticles(xMAPlabel, x);

  figure(1);

  % Plot max-marginals
  nodeBelDense = -exp(bsxfun(@minus, nodeBelDense, max(nodeBelDense, [], 2)));
  imagesc(1:T, xDense, nodeBelDense');
  colormap('gray');
  alpha(0.25);

  % imagesc flips the y-axis for some reason.
  set(gca, 'YDir', 'normal');

  hold on;
  plot(1:T, [x_true; xDenseMap; x_pred]);
%   scatter(1:T, y);

  % Plot particles
  for i = 1:T
    nS = edgeStruct.nStates(i);
    scatter(i * ones(nS, 1), x(1, 1:nS, i), 'x', 'magenta');
  end

  legend('x true', 'x dense MAP', 'x predicted');
  hold off;
  drawnow;

  if ~isfield(stats, 'L1err')
    stats.L1err = [];
  end
  stats.L1err = cat(1, stats.L1err, total(abs(x_true - x_pred)));
end
