function logpdf = normal_logpdf(x, mu, sig)
% normal_logpdf Calculate the log pdf of a univariate normal distribution.

  v = sig .^ 2;
  logpdf = -0.5 * log(2 * pi * v) - ((x - mu) .^ 2) ./ (2 * v);
end
