function [xDense, xMAP, nodeBel] = ssm1d_dense_MAP(y, model, nPoints, xmin, xmax)
% ssm1d_dense_MAP Dense MAP estimation for 1-dimensional time series models
%
%   Input:
%     y : the observed time series
%     model : the time series model
%     nPoints : the number of points in the discretization
%     xmin : the minimum x value
%     xmax : the maximum x value
%   Returns:
%     xDense : the dense particle set (1 x nPoints x T)
%     xMAP : dense MAP estimate (1 x T)
%     nodeBel : the log max-marginals (T x nPoints)

  T = size(y, 2);

  adj = zeros(T, T);
  for i = 2:T
    adj(i - 1, i) = 1;
    adj(i, i - 1) = 1;
  end

  xDense = repmat(linspace(xmin, xmax, nPoints), [1, 1, T]);

  % Max iters is set to 2 * T since it's tree-structured and all so it
  % should converge after at most 2 * T iterations.
  edgeStruct = UGM_makeEdgeStruct(adj, nPoints, true, 2 * T, 1e-4);
  edgeStruct.nDims = ones(T, 1);
  [nodePot, edgePot] = ssm_eval_model(xDense, y, model, edgeStruct);
  sched = DPMP_makeFwdBwdSched(edgeStruct);
  nodeBel = DPMP_Infer_MaxSum(nodePot, edgePot, edgeStruct, 1.0, sched);
  label = DPMP_getMAPLabel(0, nodeBel, nodePot, edgePot, edgeStruct);
  xMAP = DPMP_getLabelParticles(label, xDense);
  % nodeBel = -exp(bsxfun(@minus, nodeBel, max(nodeBel,[],2)));
end
