function [x_new] = ssm_fwd_proposal(x, nStatesAdd, model, edgeStruct)
% ssm_fwd_proposal A generic D-PMP smoothing propsal analogous to a particle
%                  filter prior proposal.
%
%  Input:
%    x : dim_x x N x T, old particles
%    nStatesAdd : a T-long vector designating the number of particles to propose
%      for each node
%    model : the SSM struct including fields for sampling from the SSM dynamics
%    edgeStruct
%  Returns:
%    x_new : dim_x x max(nStatesAdd) x T, new particles

  [dim_x, dim_y] = deal(model.dim_x, model.dim_y);
  T = size(x, 3);

  x_new = zeros([dim_x, max(nStatesAdd), edgeStruct.nNodes]);
  % Sample for node 1
  for p = 1:nStatesAdd(1)
    x_new(:,p,1) = model.pi0_rand();
  end

  % Sample rest
  for t = 2:T
    for p = 1:nStatesAdd(t)
      idx = randi(edgeStruct.nStates(t - 1));
      x_new(:,p,t) = model.trans_rand(x(:,idx,t - 1), t);
    end
  end
end
