function x0 = ssm_init_prior(N, T, model)
% ssm_init_prior Initialize particles from the "prior".
%
%   Input:
%     N : number of particles
%     T : number of time steps
%     model : the time series model
%   Returns:
%     x0 : initial particle set (dim_x x N x T)

  x0 = nan([model.dim_x, N, T]);

  for p = 1:N
    x0(:,p,1) = model.pi0_rand();
  end

  for t = 2:T
    for p = 1:N
      idx = randi(N);
      x0(:,p,t) = model.trans_rand(x0(:,idx,t - 1), t);
    end
  end
end
