function [logprob] = ssm_log_prob(x, y, model)
% ssm_log_prob Evaluate the log probability of an (x, y) sample.
%
%   Input:
%     x : dim_x x T
%     y : dim_y x T
%     model : the SSM struct including fields for evaluating the log potentials
%   Returns:
%     logprob : the log-probability of the (x, y) sample

  assert(size(x, 2) == size(y, 2));
  T = size(x, 2);

  % init edge struct
  adj = zeros(T, T);
  for i = 2:T
    adj(i - 1, i) = 1;
    adj(i, i - 1) = 1;
  end
  edgeStruct = DPMP_makeEdgeStructCont(adj, 1, 1);
  [nodePot, edgePot] = ssm_eval_model(permute(x, [1, 3, 2]), y, model, edgeStruct);
  logprob = sum(nodePot(:)) + sum(edgePot(:));
end
