function [x, y] = ssm_sample_model(model, T)
% ssm_sample_model Generates a sample from a time series model.
%
%   Input:
%     model : the time series model
%     T : the number of time steps
%   Returns:
%     x : the latent `x_{1:T}` (dim_x, T)
%     y : the observed `y_{1:T}` (dim_y, T)

  x = nan(model.dim_x, T);
  y = nan(model.dim_y, T);

  x(:,1) = model.pi0_rand();
  y(:,1) = model.obs_rand(x(:,1), 1);

  for t = 2:T
    x(:,t) = model.trans_rand(x(:,t - 1), t);
    y(:,t) = model.obs_rand(x(:,t), t);
  end
end
