function [nodeBel, iters, logP, edgeBel] = DPMP_Infer_MaxSum(...
  nodePot,edgePot,edgeStruct,stepsize,sched)

  % Run Inference  
  if edgeStruct.useMex
    [messages, iters, logP] = DPMP_MaxSumC(...
      nodePot,edgePot,int32(edgeStruct.edgeEnds),int32(edgeStruct.nStates),...
      int32(edgeStruct.V),int32(edgeStruct.E),int32(edgeStruct.maxIter),...
      edgeStruct.convTol,stepsize,int32(sched));    
    logP = logP(1:iters);
  else
    [messages, iters, logP] = ...
      DPMP_MaxSum(nodePot, edgePot, edgeStruct, stepsize,sched);      
  end
  
  % Get beliefs
  if nargout<4
    nodeBel = DPMP_getLogBeliefs(messages, nodePot, edgePot, edgeStruct);
  else  
    [nodeBel, edgeBel] = DPMP_getLogBeliefs(messages, nodePot, edgePot, edgeStruct);
  end  
end