function  [nodeBel, edgeBel, logZ, map] = DPMP_ExactMax(nodePot, edgePot, edgeStruct)
% DPMP_EXACTMAX - Exact MAP inference.
%
% J. Pacheco 2014
% Based on code by M. Schmidt
%

  [nNodes,maxStates] = size(nodePot);
  nEdges = size(edgePot,3);
  edgeEnds = edgeStruct.edgeEnds;
  nStates = edgeStruct.nStates;


  % Initialize
  nodeBel = -Inf(size(nodePot));
  edgeBel = -Inf(size(edgePot));
  y = ones(1,nNodes);
  logZ = 0;
  map = zeros( size( y ) );
  while 1
    pot = ConfigurationPotential(y,nodePot,edgePot,edgeEnds);

    % Update nodeBel
    for n = 1:nNodes
      nodeBel(n,y(n)) = max([nodeBel(n,y(n)), pot]);
    end

    % Update edgeBel
    for e = 1:nEdges
      n1 = edgeEnds(e,1);
      n2 = edgeEnds(e,2);
      edgeBel(y(n1),y(n2),e) = max([edgeBel(y(n1),y(n2),e), pot]);
    end

    % Update Z
    [logZ, idxMax] = max([logZ, pot]);
    if idxMax>1
      map = y;
    end

    % Go to next y
    for yInd = 1:nNodes      
      y(yInd) = y(yInd) + 1;
      if y(yInd) <= nStates(yInd)
        break;
      else
        y(yInd) = 1;
      end
    end

    % Stop when we are done all y combinations
    if  yInd == nNodes && y(end) == 1
      break;
    end
  end
  
  nodeBel = nodeBel - logZ;
  edgeBel = edgeBel - logZ;
end

function [pot] = ConfigurationPotential(y,nodePot,edgePot,edgeEnds)
  nNodes = size(nodePot,1);
  nEdges = size(edgeEnds,1);

  pot = 1;

  % Nodes
  for n = 1:nNodes
    pot = pot + nodePot(n,y(n));
  end

  % Edges
  for e = 1:nEdges
    n1 = edgeEnds(e,1);
    n2 = edgeEnds(e,2);
    pot = pot + edgePot(y(n1),y(n2),e);
  end
end