function logPbound = DPMP_computeTRWbound( nodeBel, edgeBel, edgeStruct, rho )
% DPMP_COMPUTETRWBOUND - Computes TRW upper bound on log-probability.
%
% J. Pacheco 2014

  nodeMaxVal = max(nodeBel, [], 2);
  logPbound = sum( nodeMaxVal );

  for e=1:edgeStruct.nEdges
    v1 = edgeStruct.edgeEnds(e,1);
    v2 = edgeStruct.edgeEnds(e,2);
    thisEdgeBel = edgeBel(:,:,e);
    maxval = max( thisEdgeBel(:) );
    logPbound = logPbound + rho(e) * ( maxval - nodeMaxVal(v1) - nodeMaxVal(v2) );
  end
end

