function [logP, logLike, logPrior] = DPMP_getLabelProb( ...
  state, ...      % NNODES x 1 label vector
  nodePot, ...    % Node log-potentials
  edgePot, ...    % Edge log-potentials
  edgeStruct ...  % MRF structure
  )
% DPMP_GETLOGPROB - Compute log-probability of label.
%
% J. Pacheco, 2014
%
  if isempty(state)
    logP = NaN;
    return;
  end
  
  nNodes = double( edgeStruct.nNodes );
  nEdges = double( edgeStruct.nEdges );

  nodeIdx = sub2ind(size(nodePot),1:nNodes,state');
  edgeSub = state( edgeStruct.edgeEnds );
  
  % if only 2 nodes mapEdgeSub can be column vector
  if size(edgeSub,2)==1, edgeSub = edgeSub'; end
  
  edgeIdx = sub2ind(size(edgePot), edgeSub(:,1), edgeSub(:,2), (1:nEdges)');
  
  logP = sum(nodePot(nodeIdx)) + sum(edgePot(edgeIdx));      
  logLike = nodePot(nodeIdx);
  logPrior = edgePot(edgeIdx);
  
end

