function [nodeBel, edgeBel] = DPMP_getLogBeliefs(msg, nodePot, edgePot, edgeStruct)
% DPMP_GETBELIEFS - Get beliefs from messages.
%
% J. Pacheco 2014
% Based on code by M. Schmidt
%

  % Init. stuff
  [nNodes,maxState] = size(nodePot);
  nEdges = edgeStruct.nEdges;
  edgeEnds = edgeStruct.edgeEnds;
  V = edgeStruct.V;
  E = edgeStruct.E;
  nStates = edgeStruct.nStates;

  % Node beliefs
  nodeBel = -Inf + zeros(nNodes, maxState);
  preMessage = -Inf + zeros(maxState, nNodes);
	for n = 1:nNodes
		edges = E(V(n):V(n+1)-1);
		preMessage(1:nStates(n),n) = nodePot(n,1:nStates(n))';
    for e = edges(:)'
      if n == edgeEnds(e,2)
        preMessage(1:nStates(n),n) = preMessage(1:nStates(n),n) + msg(1:nStates(n),e);
      else
        preMessage(1:nStates(n),n) = preMessage(1:nStates(n),n) + msg(1:nStates(n),e+nEdges);
      end
    end
    nodeBel(n,1:nStates(n)) = preMessage(1:nStates(n),n)' - max(preMessage(1:nStates(n),n)); 
  end
  
  % Compute edge beliefs  
  if nargout > 1   
     edgeBel = -Inf + zeros(maxState,maxState,nEdges);
     for e = 1:nEdges
        n1 = edgeEnds(e,1);
        n2 = edgeEnds(e,2);

        % sum incoming messages by removing messages between n1 & n2 from node beliefs
        belN1 = nodeBel(n1,1:nStates(n1))' - msg(1:nStates(n1),e+nEdges);
        belN2 = nodeBel(n2,1:nStates(n2))' - msg(1:nStates(n2),e);

        % combine aggregate messages with edge potential
        b_unary = bsxfun(@plus, belN1, belN2');
        edgeBel(1:nStates(n1),1:nStates(n2),e) = b_unary + edgePot(1:nStates(n1),1:nStates(n2),e);      
        edgeBel(1:nStates(n1),1:nStates(n2),e) = edgeBel(1:nStates(n1),1:nStates(n2),e)- ...
        max(max(edgeBel(1:nStates(n1),1:nStates(n2),e)));
     end
  end 
end