function [mapState, nTies] = DPMP_getMAPLabel(...
  doTieRes, ...   % Resolve ties with J-Tree? (binary: can be slow)
  nodeBel, ...    % Node (log)-beliefs
  nodePot, ...    % Node (log)-potentials
  edgePot, ...    % Edge (log)-potentials
  edgeStruct ...  % MRF structure
  )

  % get tied states
  [maxBel,mapState] = max(nodeBel, [], 2);
  D = bsxfun(@minus, maxBel, nodeBel);
  bIsMax = D < 10*edgeStruct.convTol; % edgeStruct.convTol; % 
    
  % clamp unique assignments  
  bUniqueNode = sum(bIsMax,2)==1;  
  clamped = zeros( size( mapState ) );
  clamped( bUniqueNode ) = mapState( bUniqueNode );
  [nodePot_clamped, edgePot_clamped, edgeStruct_clamped] = ...
    DPMP_makeClampedPotentials(nodePot, edgePot, edgeStruct, clamped);
  nTies = sum(~bUniqueNode);
  
  % handle ties
  if doTieRes && nTies
    maxState = max( edgeStruct.nStates );
    idxTied = find( ~bUniqueNode );
    
    % remove non-tied states  
    for v_i=1:numel(idxTied)
      v = idxTied(v_i);
      thisTies = bIsMax(v,:);
      edgeStruct_clamped.nStates(v_i) = sum( thisTies );
      thisPot = nodePot_clamped( v_i, thisTies );
      nodePot_clamped(v_i,:) = -Inf + zeros(maxState,1);
      nodePot_clamped(v_i,1:numel(thisPot)) = thisPot;    
    end
    for e=1:edgeStruct_clamped.nEdges
      v1 = idxTied( edgeStruct_clamped.edgeEnds(e,1) );
      v2 = idxTied( edgeStruct_clamped.edgeEnds(e,2) );
      thisTies1 = bIsMax(v1,:);
      thisTies2 = bIsMax(v2,:);
      thisPot = edgePot_clamped(thisTies1,thisTies2,e);
      edgePot_clamped(:,:,e) = -Inf + zeros([maxState,maxState]);
      edgePot_clamped(1:sum(thisTies1),1:sum(thisTies2),e) = thisPot;
    end

    % run junction tree
    try
      nodeBelJ = DPMP_Infer_JunctionMax(nodePot_clamped,edgePot_clamped,edgeStruct_clamped);
    catch ME
      if strcmp(ME.identifier, 'DPMP_makeJunctionTree:CliqueTooLarge')
        fprintf('Clique size too large.\n');
        return;
      else
        rethrow(ME);
      end
    end
    
    % set remaining states
    [~,mapStateTied] = max(nodeBelJ,[],2);
    for v_i=1:numel(idxTied)
      v = idxTied(v_i);
      allStates = 1:maxState;
      tiedStates = allStates( bIsMax(v,:) );
      mapState( v ) = tiedStates( mapStateTied(v_i) );
    end
  end
end

