function [nodeBel, edgeBel] = DPMP_getTRWLogBeliefs(msg, nodePot, edgePot, edgeStruct, mu, normalize)
% DPMP_GETBELIEFS - Get beliefs from messages.
%
% J. Pacheco 2014
% Based on code by M. Schmidt
%
  if nargin<6
    normalize = true;
  end

  % Init. stuff
  [nNodes,maxState] = size(nodePot);
  nEdges = size(edgePot,3);
  edgeEnds = edgeStruct.edgeEnds;
  V = edgeStruct.V;
  E = edgeStruct.E;
  nStates = edgeStruct.nStates;
  
  %% Compute nodeBel
  nodeBel = -Inf + zeros(nNodes,maxState);
  preMessage = -Inf + zeros( maxState, nNodes );
  for n = 1:nNodes
    edges = E(V(n):V(n+1)-1);
    preMessage(1:nStates(n),n) = nodePot(n,1:nStates(n))';
    for e = edges(:)'
      if n == edgeEnds(e,2)
        preMessage(1:nStates(n),n) = preMessage(1:nStates(n),n) + mu(e) * msg(1:nStates(n),e);
      else
        preMessage(1:nStates(n),n) = preMessage(1:nStates(n),n) + mu(e) * msg(1:nStates(n),e+nEdges);
      end
    end    
    nodeBel(n,1:nStates(n)) = preMessage(1:nStates(n),n)';
    if normalize
      logZ = max( nodeBel(n,1:nStates(n)) );
      nodeBel(n,1:nStates(n)) = nodeBel(n,1:nStates(n)) - logZ;
    end
  end

  %% Compute edgeBel
  if nargout > 1
    edgeBel = -Inf + zeros(maxState,maxState,nEdges);
    for e = 1:nEdges
      n1 = edgeEnds(e,1);
      n2 = edgeEnds(e,2);

      % temp1 = nodePot by all messages to n1 except from n2
      edges = E(V(n1):V(n1+1)-1);
      temp1 = nodePot(n1,1:nStates(n1))';
      for e2 = edges(:)'
        if n1 == edgeEnds(e2,2)
          incoming = msg(1:nStates(n1),e2);
        else
          incoming = msg(1:nStates(n1),e2+nEdges);
        end
        if e ~= e2
          temp1 = temp1 + mu(e2) * incoming;
        else
          temp1 = temp1 - (1-mu(e2)) * incoming;
        end
      end

      % temp2 = nodePot by all messages to n2 except from n1
      edges = E(V(n2):V(n2+1)-1);
      temp2 = nodePot(n2,1:nStates(n2))';
      for e2 = edges(:)'
        if n2 == edgeEnds(e2,2)
          incoming = msg(1:nStates(n2),e2);
        else
          incoming = msg(1:nStates(n2),e2+nEdges);
        end
        if e ~= e2
          temp2 = temp2 + mu(e2) * incoming;
        else
          temp2 = temp2 - (1-mu(e2)) * incoming;
        end
      end

      edgeBel(1:nStates(n1),1:nStates(n2),e) = repmat(temp1,[1 nStates(n2)]) + ...
        repmat(temp2',[nStates(n1) 1]) + (1/mu(e)) * edgePot(1:nStates(n1),1:nStates(n2),e);
      if normalize
        edgeBel(1:nStates(n1),1:nStates(n2),e) = edgeBel(1:nStates(n1),1:nStates(n2),e)- ...
          max(max(edgeBel(1:nStates(n1),1:nStates(n2),e)));
      end
    end
  end
end