function edgeStruct = DPMP_makeEdgeStructCont(...
  adj, ...      % Adjacency matrix NNODES x NNODES (binary)
  nStates, ...  % Number states (scalar or NNODES vector)
  nDims, ...    % Number dimensions (scalar or NNODES vector)
  useMex, ...   % Use Mex code? (binary)
  maxIter, ...  % Maximum inference iterations (default 100)
  convTol ...   % MP/RMP Convvergence tolerance (default 1e-4)
  )
% DPMP_MAKEEDGESTRUCTCONT - Make edge data structure for continuous MRF.  
%
% EDGESTRUCT = DPMP_MAKEEDGESTRUCTCONT(ADJ, NSTATES, NDIMS, USEMEX,
%   MAXITER, CONVTOL ) Returns an edge structure from a (sparse) adjacency
%   matrix ADJ.  Each node V has NSTATES(V) states and NDIMS(v) dimensions.
%
% J. Pacheco 2014
% Based on code by M. Schmidt
%

if nargin < 4
  edgeStruct = UGM_makeEdgeStruct(adj,nStates);
elseif nargin < 5
  edgeStruct = UGM_makeEdgeStruct(adj,nStates,useMex);
elseif nargin < 6
  edgeStruct = UGM_makeEdgeStruct(adj,nStates,useMex,maxIter);
else
  edgeStruct = UGM_makeEdgeStruct(adj,nStates,useMex,maxIter,convTol);
end

% dimension of continuous states
nNodes = int32(length(adj));
if isscalar(nDims)
  nDims = repmat(nDims,[double(nNodes) 1]);
end
edgeStruct.nDims = nDims;
