function msgMat = DPMP_msgFoundation( srcNode, edgeIdx, msg, nodePot, edgePot, edgeStruct )
% DPMP_MSGFOUNDATION - Form message foundation matrix.
%
% J. Pacheco 2014
%

  nStates = edgeStruct.nStates;
  nEdges = edgeStruct.nEdges;
  edgeEnds = edgeStruct.edgeEnds;
  
  % get edge ends
  v1 = edgeEnds(edgeIdx,1);
  v2 = edgeEnds(edgeIdx,2);
  edges = UGM_getEdges(srcNode,edgeStruct);

  % collect incoming messages
  temp = nodePot(srcNode,1:nStates(srcNode))';
  for e2 = edges
    if edgeIdx == e2, continue; end
    if srcNode == edgeEnds(e2,2)
      temp = temp + msg(1:nStates(srcNode),e2);
    else
      temp = temp + msg(1:nStates(srcNode),e2+nEdges);
    end
  end

  % compute message foundation matrix
  if srcNode == edgeEnds(edgeIdx,2)
    pot_ij = edgePot(1:nStates(v1),1:nStates(v2),edgeIdx);
  else
    pot_ij = edgePot(1:nStates(v1),1:nStates(v2),edgeIdx)';
  end
  msgMat = bsxfun(@plus, pot_ij, temp');

end

