function msgMat = DPMP_msgFoundationTRW( srcNode, edgeIdx, msg, nodePot, edgePot, edgeStruct, mu )
% DPMP_MSGFOUNDATIONTRW - Form message foundation matrix for TRW messages
%
% J. Pacheco 2014
%

  nStates = edgeStruct.nStates;
  nEdges = edgeStruct.nEdges;
  edgeEnds = edgeStruct.edgeEnds;
  
  % get edge ends
  v1 = edgeEnds(edgeIdx,1);
  v2 = edgeEnds(edgeIdx,2);
  edges = UGM_getEdges(srcNode,edgeStruct);
  
  % Compute temp = product of all incoming msgs except j
  %   to the power of the edge appearance probability,
  %   divided by msg from j to the (1 - edge appearnce prob)
  temp = nodePot(srcNode,1:nStates(srcNode))';
  for e2 = edges
    if srcNode == edgeEnds(e2,2)
      incoming = msg(1:nStates(srcNode),e2);
    else
      incoming = msg(1:nStates(srcNode),e2+nEdges);
    end
    if edgeIdx ~= e2
      temp = temp + mu(e2)*incoming;
    else
      temp = temp - (1-mu(e2))*incoming;
    end
  end

  % compute message foundation matrix
  if srcNode == edgeEnds(edgeIdx,2)
    pot_ij = edgePot(1:nStates(v1),1:nStates(v2),edgeIdx);
  else
    pot_ij = edgePot(1:nStates(v1),1:nStates(v2),edgeIdx)';
  end
  
  % Adjust edge potential by edge appearnce probability
  pot_ij = (1/mu(edgeIdx)) * pot_ij;  

  msgMat = bsxfun(@plus, pot_ij, temp');
end

