function [x, I_accept, N_accept] = DPMP_selectDiverse( ...
  x_aug, nParticlesSelect, msg, nodePot, edgePot, edgeStruct, ...
  Temp, lbpType, rho, labelMAP )
% DPMP_SELECTDIVERSE - Diverse particle selection based on min-max
%   objective.
%
% J. Pacheco 2014
%

  % Init. stuff
  [ nParticles, nNodes, edgeEnds ] = deal( ...
    edgeStruct.nStates, edgeStruct.nNodes, edgeStruct.edgeEnds );
  maxDim = size(x_aug,1);
  x = zeros(maxDim, max(nParticlesSelect), nNodes);
  
  % foreach node
  I_accept = zeros(nNodes, max(nParticlesSelect));
  N_accept = zeros(nNodes,1);
  for v=1:nNodes
    
    % append outgoing messages
    edges = UGM_getEdges(v,edgeStruct);
    logPsi = []; 
%     logPsi_test = []; logMstar_test = [];
    for e = edges            
      v1 = edgeEnds(e,1);
      v2 = edgeEnds(e,2);
      if (v==v2), nodeDest = v1; else nodeDest = v2; end
      
      % compute message foundation
      switch lower(lbpType)
        case 'lbp'
          msgMat = DPMP_msgFoundation( v, e, msg, nodePot, edgePot, edgeStruct);
        case 'trw'
          msgMat = DPMP_msgFoundationTRW( v, e, msg, nodePot, edgePot, edgeStruct, rho);    
      end
      logPsi = cat(1, logPsi, ...
        msgMat(1:nParticles(nodeDest), 1:nParticles(v)) );
    end    
        
    % normalize & exponentiate
    logMstar = max(logPsi, [], 2);
    logZ = 1/Temp * max( logPsi(:) );
    Mstar = exp(1/Temp * logMstar - logZ);
    Psi = exp(1/Temp * logPsi - logZ);
    
    % select first particle
    D = bsxfun( @minus, Mstar, Psi );
    if nargin<10
      [min_a, argmax_a] = max( D, [], 1 );
      [min_b, b] = min( min_a );
    else
      b = labelMAP(v);
    end
    M_hat = Psi( :, b );
    delta = Mstar - M_hat;
    I_accept(v,1) = b;
    m = 1;    
          
    % select particles   
    while (m<nParticlesSelect(v)) && (max(delta)>0)       
      m = m+1;

      % get unused particles
      b_used = I_accept(v,1:m-1);
      b_unused = 1:nParticles(v);
      b_unused( b_used ) = [];

      % select next particle
      [min_a, a_star] = max(delta);
      [min_b, idx_max] = max( Psi(a_star, b_unused), [], 2 );
      b = b_unused( idx_max );
      I_accept(v,m) = b;        
            
      % update message approx
      M_hat = max( [ M_hat, Psi( :, b ) ], [], 2 );      
      delta = Mstar - M_hat;
    end    
    N_accept(v) = m;
    
    % select x    
    x(:,1:N_accept(v),v) = x_aug(:,I_accept(v,1:N_accept(v)),v);
  end  
end

