function [x, I_accept, N_accept] = DPMP_selectLazyGreedy(...
  x_aug, ...
  nParticlesSelect, ...
  msg, ...
  nodePot, ...
  edgePot, ...
  edgeStruct, ...
  Temp, ...
  lbpType, ...
  rho, ...
  labelMAP ...
  )
% DPMP_SELECTLAZYGREEDY - "Lazy Greedy" particle selection.
%
% REFERENCE:
% Pacheco, J. and Sudderth, E., "Proteins, Particles, and
%   Pseudo-Max-Marginals: A Submodular Approach.", ICML 2015
%
% J. Pacheco, 2014
%

  % Init. stuff
  [ nParticles, nNodes, edgeEnds ] = deal( ...
    edgeStruct.nStates, edgeStruct.nNodes, edgeStruct.edgeEnds );
  maxDim = size(x_aug,1);
  x = zeros(maxDim, max(nParticlesSelect), nNodes);
  
  % foreach node
  I_accept = zeros(nNodes, max(nParticlesSelect));
  N_accept = zeros(nNodes,1);
  for v=1:nNodes
    
    % append outgoing messages
    edges = UGM_getEdges(v,edgeStruct);
    logPsi = []; 
%     logPsi_test = []; logMstar_test = [];
    for e = edges            
      v1 = edgeEnds(e,1);
      v2 = edgeEnds(e,2);
      if (v==v2), nodeDest = v1; else nodeDest = v2; end
      
      % compute message foundation
      switch lower(lbpType)
        case 'lbp'
          msgMat = DPMP_msgFoundation( v, e, msg, nodePot, edgePot, edgeStruct);
        case 'trw'
          msgMat = DPMP_msgFoundationTRW( v, e, msg, nodePot, edgePot, edgeStruct, rho);    
      end
      logPsi = cat(1, logPsi, ...
        msgMat(1:nParticles(nodeDest), 1:nParticles(v)) );
    end    
        
    % normalize & exponentiate
    logMstar = max(logPsi, [], 2);
    logZ = 1/Temp * max( logPsi(:) );
    Mstar = exp(1/Temp * logMstar - logZ);
    Psi = exp(1/Temp * logPsi - logZ);
    
    % select first particle
    delta = sum( Psi, 1 );
    if nargin<10      
      [~, b] = max(delta);
    else
      b = labelMAP(v);
    end
    I_accept(v,1) = b; 
    M_hat = Psi(:,b);
    N_accept(v) = 1;
    m = 1;
              
    % select particles   
    deltaMax = Inf;
    while (m<nParticlesSelect(v)) && (deltaMax>0)       
      m = m+1;
              
      % get unused particles
      b_used = I_accept(v,1:m-1);
      b_unused = 1:nParticles(v);
      b_unused( b_used ) = [];

      % pick next particle    
      stale = ones([nParticles(v),1]);  
      for i=1:(numel(b_unused)+1)
        
        % pick highest margin
        [deltaMax, idxMax] = max( delta(b_unused) );          
        bMax = b_unused( idxMax );
        if ~stale( bMax ), break; end
        
        % recompute margin          
        tmp_M = max( [M_hat, Psi(:,bMax)], [], 2 );
%           if ( delta_vec(bMax) < (sum( tmp_M ) - sum(M_hat)) ), keyboard; end
        delta(bMax) = sum( tmp_M ) - sum(M_hat); 
        stale(bMax) = 0;
      end    

      % add particle
      if deltaMax>0
        I_accept(v,m) = bMax;
        M_hat = max( [M_hat, Psi(:,bMax)], [], 2 ); 
        N_accept(v) = m;        
      end     
    end    
    
    % select x    
    x(:,1:N_accept(v),v) = x_aug(:,I_accept(v,1:N_accept(v)),v);
  end
end

