function [x, I_accept] = DPMP_selectMBest( x_aug, nSelect, nodeBel, edgeStruct, labelMAP )
% DPMP_SELECTMBEST - Select M particles with highest max-marginal values.
%
% J. Pacheco 2014
%

  % Init. stuff
  [ nParticles, nNodes, nDims ] = deal( ...
    edgeStruct.nStates, edgeStruct.nNodes, edgeStruct.nDims );
  maxDims = max(nDims);
  x = zeros(maxDims, max(nSelect), nNodes);
  
  % select nodes
  I_accept = zeros(nNodes, max(nSelect));
  for v=1:nNodes
    if nSelect(v) <= 0, continue; end
    [~, idxSort] = sort(nodeBel(v,:), 'descend');    
    if nargin<5      
      I_accept(v,:) = idxSort(1:nSelect(v));
    else
      I_accept(v,1) = labelMAP(v);
      idxSort( idxSort == labelMAP(v) ) = [];
      I_accept(v,2:nSelect(v)) = idxSort(1:nSelect(v)-1);
    end
    x(:,1:nSelect(v),v) = x_aug(1:maxDims,I_accept(v,1:nSelect(v)),v);    
  end
end

