function options = DPMP_setOptions( ...
  verbose,  ...     % Level of verbosity (0,1)
  display_iter, ... % # iterations to call display callback
  selectType, ...   % Particle Selection: 'tpmp', 'gpmp', 'dpmpsum', 'dpmpmax'
  msgPass, ...      % Message Passing: "lbp', 'trw'
  nParticles, ...   % Total particle budget by node (scalar or vector)
  maxIters, ...     % Number PMP iterations
  maxItersLBP, ...  % Maximum MP/RMP iterations (default 100)
  sampleProb, ...   % Probability for each proposal (probability vector)
  Temp, ...         % "Annealing" temperature for particle selection
  stepsize, ...     % MP/RMP stepsize
  convTolBP, ...    % MP/RMP message convergence tolerance (default 1e-4)
  useMex, ...       % Use Mex code?  (0,1)
  doTieRes ...      % Resolve ties with J-Tree? (0,1)
  )
% DPMP_SETOPTIONS - Set options for all PMP methods.
%
% J. Pacheco, 2015
%

  options.verbose = verbose;
  options.display_iter = display_iter;
  options.selectType = selectType;
  options.msgPass = msgPass;
  options.nParticles = nParticles;
  options.maxIters = maxIters;
  options.maxItersLBP = maxItersLBP;
  options.sampleProb = sampleProb;
  options.Temp = Temp;
  options.stepsize = stepsize;
  options.convTolBP = convTolBP;
  options.useMex = useMex;
  options.doTieRes = doTieRes;
  
  % check options
  if sum(options.sampleProb) ~= 1.0
    error('DPMP_setOptions: Sample probabilities dont add to 1.0.');
  end
  if any(options.sampleProb < 0.0)
    error('DPMP_setOptions: Samaple probabilities must be non-negative.');
  end
end

