function [nodePot, edgePot] = DPMP_subsetPotentials(...
  nStates, acceptIdx, nodePot_aug, edgePot_aug, edgeStruct)

  nNodes = edgeStruct.nNodes;
  nEdges = edgeStruct.nEdges;
  
  %% TODO: Vectorize this with indexing
  
  % init 
  nodePot = zeros(nNodes,max(nStates));
  edgePot = zeros(max(nStates),max(nStates),nEdges);

  % update node potentials
  for v=1:nNodes
    nodePot(v,1:nStates(v)) = nodePot_aug(v, acceptIdx(v,1:nStates(v)));  
  end    
    
  % update edge potentials  
  msg = zeros(max(nStates),2*nEdges);
  msg_argmax = zeros(max(nStates),2*nEdges);
  for e=1:nEdges
    this_edge = edgeStruct.edgeEnds(e,:);
    v1 = min( this_edge );
    v2 = max( this_edge );
    edgePot(1:nStates(v1), 1:nStates(v2), e) = ...
      edgePot_aug(acceptIdx(v1,1:nStates(v1)), acceptIdx(v2,1:nStates(v2)), e);  
  end
end