function cfg = DPMP_topMConfigs( mode_vec, msg, msg_argmax, nodePot, edgePot, edgeStruct )

  VERBOSE = 1;
  
  [nNodes, nEdges, edgeEnds, nStates] = deal( ...
    edgeStruct.nNodes,edgeStruct.nEdges,edgeStruct.edgeEnds,edgeStruct.nStates);
  
  % sort max-marginal beliefs
  nodeBel = DPMP_getLogBeliefs(msg, nodePot, edgePot, edgeStruct);
  [nodeBelSort, IdxSort] = sort( nodeBel(:), 'descend' );
  assert(numel(unique(nodeBelSort(:)))>=mode_vec(end));
  
  % calculate modes
  cfg = zeros(numel(mode_vec),nNodes);
  j = 0; logP = Inf; m=0;
  for m_i=1:numel(mode_vec)
    stale = true(nNodes,1);
    
    % find next highest max-marginal value    
    for k=(j+1):sum(nStates);
      if logP - nodeBelSort(k) < eps, continue; end            
      m = m+1;
      if (m==mode_vec(m_i))
        break; 
      end
    end
    logP = nodeBelSort(k);
    assert(~isinf(logP));
    [vRoot,i_root] = ind2sub(size(nodeBel), IdxSort(k));      
        
    % set first node label    
    cfg(m_i,vRoot) = i_root;    
    stale(vRoot) = false;
    edgeQ = UGM_getEdges(vRoot,edgeStruct);
    
    % set wall clock time
    if VERBOSE, t_start = tic(); end
    
    % set remaining configuration
    while sum(stale)>0
      
      % pop edge
      e = edgeQ(1);
      edgeQ = edgeQ(2:end);
      
      % message eDirIdx goes vSrc->vDst with vSrc stale
      if stale(edgeEnds(e,1))
        vSrc = edgeEnds(e,1);
        vDst = edgeEnds(e,2);        
        eDirIdx = e;
      else
        vSrc = edgeEnds(e,2);
        vDst = edgeEnds(e,1);
        eDirIdx = e + nEdges;
      end
      assert(~stale(vDst));
      
      % if we already did this node, skip
      if (~stale(vSrc)), 
        continue; 
      end
        
      % viterbi step
      cfgParent = cfg(m_i,vDst);
      cfg(m_i,vSrc) = msg_argmax(cfgParent,eDirIdx);
      stale(vSrc) = false;
      
      % push edges
      edgesChild = UGM_getEdges(vSrc,edgeStruct);
      for e2 = edgesChild
        if stale(edgeEnds(e2,1)) || stale(edgeEnds(e2,2))
          edgeQ = [edgeQ, e2];
        end
      end      
    end
    assert( sum(stale)==0 );
    
    if VERBOSE
      fprintf('Configuration %d found (%fs).\n', mode_vec(m_i), toc(t_start));
    end
  end
      
  