function h = barpolar( h, theta, rad, linespec )
% BARPOLAR - Polar bar plot.
%
% J. Pacheco, 2014
%

  % Determine bin edges
  edges = sort(rem([(theta(2:end)+theta(1:end-1))/2 (theta(end)+theta(1)+2*pi)/2],2*pi));
  edges = [edges edges(1)+2*pi];
  
  % Form radius values for triangle
  [m,n] = size(rad);
  mm = 4*n;
  r = zeros(mm,m);
  r(2:4:mm,:) = rad;
  r(3:4:mm,:) = rad;
  
  % Form theta values for histogram triangle from triangle centers (xx)
  t = zeros(mm,1);
  t(2:4:mm) = [ 0 theta(2:end) ];
  t(3:4:mm) = [ theta(2:end) 0 ];
    
  % plot
  if ~isempty(h)
    h = polar(h,t,r,linespec);
  else
    h = polar(t,r,linespec);
  end  
  
  % patch
  x = get(h,'Xdata');
  y = get(h,'Ydata');
  g = patch(x,y,linespec);
end

