#ifndef _DYN_H_
#define _DYN_H_

#include "core_obj.h"

class CRuntimeClass;
extern CRuntimeClass * g_rLastClass;

class CRuntimeClass {
private:
  CString m_sClassName;
  CString m_sBaseName;
  CRuntimeClass * m_pNext;
public:
  CRuntimeClass(const char * aName, const char * aBase) : 
    m_sClassName(aName), m_sBaseName(aBase) {
      m_pNext = g_rLastClass;
      g_rLastClass = this;
  }
  virtual CObject * CreateObject()=0;
  bool Is(const char * aName);
  CRuntimeClass * GetNext() const { return m_pNext; }
  const CString & GetBaseName() const { return m_sBaseName; }
  CString GetBaseName() { return m_sBaseName; }
};

CRuntimeClass * FindClass(const char * aClassName);
CObject * NewByName(const char * aName);
CString GetBaseOf(const char * aClass);
bool KindOf(const char * aClass, const char * aBase);

////////////////////////////////////////////////
// Declarations

#define DECLARE_DYNAMIC(CLASSNAME) \
public:\
virtual bool IsKindOf(const char * );\
virtual CRuntimeClass * GetRuntimeClass();\
static CRuntimeClass * m_pRC##CLASSNAME;\
private:

#define IMPLEMENT_DYNAMIC( CLASSNAME, BASENAME ) \
class CRuntime##CLASSNAME : public CRuntimeClass {\
public:\
  CRuntime##CLASSNAME(CString aName, CString aBase) : \
    CRuntimeClass(aName, aBase) {}\
  virtual CObject * CreateObject();\
};\
CObject * CRuntime##CLASSNAME::CreateObject(){\
  return new CLASSNAME;\
}\
bool CLASSNAME::IsKindOf(const char * aName){\
  return KindOf(#CLASSNAME, aName);\
}\
CRuntimeClass * CLASSNAME::GetRuntimeClass(){\
  return m_pRC##CLASSNAME;\
}\
CRuntime##CLASSNAME Runtime##CLASSNAME(#CLASSNAME, #BASENAME);\
CRuntimeClass * CLASSNAME::m_pRC##CLASSNAME = & Runtime##CLASSNAME;


#endif
