#ifndef _LIST_H_
#define _LIST_H_

#include "core_except.h"
#include "core_ref.h"

template<class TYPE>
class CNode{
protected:
  CNode   * m_pNext;
  CNode   * m_pPrev;
public:
  Ref<TYPE> m_pObject;  
  TYPE * Val() { return m_pObject; }
  CNode() {
    m_pNext = this;
    m_pPrev = this;
  }
  CNode(TYPE * pObject) {
    m_pNext = this;
    m_pPrev = this;
    m_pObject = pObject;
  }
  ~CNode() {
    // remove the node from the structure
    m_pNext->m_pPrev = m_pPrev;
    m_pPrev->m_pNext = m_pNext;
  }
  void InsertAfter(CNode * pNode){
    // The node must be free
    ASSERT( (m_pNext==this) && (m_pPrev==this) );
    m_pNext = pNode->m_pNext;
    pNode->m_pNext->m_pPrev = this;
    pNode->m_pNext=this;
    m_pPrev=pNode;
  }
  void InsertBefore(CNode * pNode){
    // The node must be free
    ASSERT( (m_pNext==this) && (m_pPrev==this) );
    m_pPrev = pNode->m_pPrev;
    pNode->m_pPrev->m_pNext = this;
    pNode->m_pPrev=this;
    m_pNext=pNode;
  }
  CNode * Next() { return m_pNext; }
  CNode * Prev() { return m_pPrev; }
};

template<class TYPE>
class CList : public CNode<TYPE> {
private:
  unsigned long m_lSize;
public:
  CList() { m_lSize=0; }
  void Add(TYPE * rTyp){
    if(Find(rTyp)) return;
    CNode<TYPE> * pNode;
    pNode = new CNode<TYPE>;
    VERIFY_MSG(pNode!=NULL,"Memory allocation failure.");
    pNode->m_pObject = rTyp;
    pNode->InsertBefore(this);
    m_lSize++;
  }
  CNode<TYPE> * Find(TYPE * rObj){
    CNode<TYPE> * q=Next();
    while(q!=this){
      if(rObj==(TYPE *)q->m_pObject)
	return q;
      else
	q=q->Next();
    }
    return 0L;
  }
  bool Remove(TYPE * rTyp){
    CNode<TYPE> * res = Find(rTyp);
    if(!res) return false;
    delete res;
    m_lSize--;
    return true;
  }
  bool Has(TYPE * p){
    return 0!=Find(p);
  }
  TYPE * GetAny(){
    return m_pNext->m_pObject;
  }
  ~CList(){
    while(m_pNext!=this) delete m_pNext;
  }
  unsigned long GetSize() { return m_lSize; }
};

#define ForEach(ACLASS, NAME, ATYPE, LIST)\
ACLASS * NAME;\
for(CNode<ATYPE> * node##NAME=LIST.Next();\
node##NAME!=&LIST;node##NAME=node##NAME->Next())\
if((NAME = (ACLASS *) node##NAME->Val()) && (NAME->IsKindOf(#ACLASS)))
  
#define StrictForEach(ACLASS, NAME, ATYPE, LIST)\
ACLASS * NAME;\
for(CNode<ATYPE> * node##NAME=LIST.Next();\
node##NAME!=&LIST;node##NAME=node##NAME->Next())\
if((NAME = (ACLASS *) node##NAME->Val()) && \
(NAME->GetRuntimeClass()== ACLASS::m_pRC##ACLASS))

#endif
