#include "core_except.h"
#include "core_str.h"

#include <stdio.h>
#include <string.h>

CString::CString(int i){
  m_iLength = 0;
  m_pChar   = 0;
  m_iSize   = 0;
  Allocate(i);
  *m_pChar  = '\0';		
}

CString::CString() {
  m_iLength = 0;
  m_pChar   = 0;
  m_iSize   = 0;
  Allocate(0);
  *m_pChar  = '\0';		
}

CString::CString(const char * pChar){
  int len = strlen(pChar);
  m_iLength = 0;
  m_pChar   = 0;
  m_iSize   = 0;
  Allocate(len);
  strcpy(m_pChar, pChar);
}

CString::CString(const char & rChar){
  m_iLength = 0;
  m_pChar   = 0;
  m_iSize   = 0;
  Allocate(1);
  m_pChar[0] = rChar;
  m_pChar[1] = '\0';
}

CString::CString(const long & rLong){
  m_iLength = 0;
  m_pChar   = 0;
  m_iSize   = 0;
  char buffer[80];
  sprintf(buffer,"%ld",rLong);
  int len = strlen(buffer);
  Allocate(len);
  strcpy(m_pChar, buffer);
}

CString::CString(const CString & s){
  m_iLength = 0;
  m_pChar   = 0;
  m_iSize   = 0;
  Allocate(s.m_iLength);
  strcpy(m_pChar, s.m_pChar);
}

CString & CString::operator = (const CString & s){
  Allocate(s.m_iLength);
  strcpy(m_pChar, s.m_pChar);
  return (*this);
}

CString::~CString() {
  if(m_pChar) delete [] m_pChar;
}


void CString::Allocate(int aLength){
  int bestSize = (aLength | 0xF)+1;
  if(m_iSize!=bestSize){
    char * pChar = new char[bestSize];
    VERIFY_MSG(pChar!=NULL, "Memory allocation failure.");
    if(m_pChar){
      strcpy(pChar, m_pChar);
      delete [] m_pChar;
    }
    m_iSize = bestSize;
    m_pChar = pChar;
  }	
  m_iLength = aLength;
}

CString CString::Left(int ind){
  ASSERT( (0<=ind) && (ind<=m_iLength) );
  CString s(ind);
  int i;
  for(i=0;i<ind;i++){
    s.m_pChar[i]=m_pChar[i];
  }
  s.m_pChar[i]='\0';
  return s;
}

CString CString::Right(int ind){
  ASSERT( (0<=ind) && (ind<=m_iLength) );
  CString s(ind);
  int i;
  int dif=m_iLength-ind;
  for(i=0;i<ind;i++){
    s.m_pChar[i]=m_pChar[i+dif];
  }
  s.m_pChar[i]='\0';
  return s;
}

CString & CString::operator += (const CString & s){
  int l1 = m_iLength;
  int l2 = s.m_iLength;
  int len = l1+l2;;
  Allocate(len);
  char * pStart = m_pChar+l1;
  memcpy(pStart,s.m_pChar,l2);
  m_pChar[len]='\0';
  return *this;
}

bool CString::operator == (const CString & s) const {
  if(m_iLength!=s.m_iLength) return false;
  return strcmp(m_pChar,s.m_pChar)==0;
}

CString operator + (const CString & a, const CString & b){
  CString c(a);
  c+=b;
  return c;
}
