#ifndef _STR_H_
#define _STR_H_

#include "core_except.h"

class CString {
private:
  char * m_pChar;
  int    m_iLength;
  int		 m_iSize;
  
  CString(int i);
public:
  // construction
  CString();
  CString(const char * pChar);
  CString(const char & rChar);
  CString(const long & rLong);
  CString(const CString & s);
  CString & operator = (const CString & s);
  // destruction
  virtual ~CString();
  // indexing
  char & operator [] (int i){
    ASSERT( (i>=0) && (i<m_iLength) );
    return m_pChar[i];
  }
  const char & operator [] (int i) const{
    ASSERT( (i>=0) && (i<m_iLength) );
    return m_pChar[i];
  }
  
  // compatibility with char *
  operator char * () { return m_pChar; }
  operator const char * () const { return m_pChar; }
  
  // size
  int GetLength() const { return m_iLength; }
  void Allocate(int);
  
  // concat
  CString & operator += (const CString & s);
  bool operator == (const CString & s) const;
  CString Left(int ind);
  CString Right(int ind);
};

CString operator + (const CString & a, const CString & b);
#endif
