#include "core.h"
#include "mod.h"
#include "db.h"
#include "lib.h"

#include <stdio.h>

CString Difference_temp_vt(CSession * pSession, const CString & q1, const CString & q2){  
  //////////////////////////////
  // Parse the queries
  CCursor c1(pSession,q1);
  CCursor c2(pSession,q2);

  //////////////////////////////
  // Construct a table for the result
  CString tempName=CreateTempTableFrom(pSession, q1);  
  Ref<CRectSet> pRects = new CRectSet;

  CRow r1(&c1);
  CRow r2(&c2);
  CCursor c3(pSession,tempName, &r1);

  c1.Execute();
  while(r1.Fetch()){
    c2.Execute();
    CRectRef rect1=r1.GetTempVt();
    CRectRef rect2;
    while(r2.Fetch()){
      if(IdenticalValues(r1,r2)){
	rect2=r2.GetTempVt();	
	if(Overlap(*rect1,*rect2)){
	  Associate(pRects,rect2);
	}
      }
    }
    CSetRef res = Difference(*rect1, pRects);
    pRects->Erase();
    StrictForEachAssociate(CRectangle, result, res){
      r1.SetTempVt(result);
      c3.Execute();
    }
    res->Erase();
  }
  return tempName;
}

CString Difference_temp_tt(CSession * pSession, const CString & q1, const CString & q2){  
  //////////////////////////////
  // Parse the queries
  CCursor c1(pSession,q1);
  CCursor c2(pSession,q2);

  //////////////////////////////
  // Construct a table for the result
  CString tempName=CreateTempTableFrom(pSession, q1);  
  Ref<CRectSet> pRects = new CRectSet;

  CRow r1(&c1);
  CRow r2(&c2);
  CCursor c3(pSession,tempName, &r1);

  c1.Execute();
  while(r1.Fetch()){
    c2.Execute();
    CRectRef rect1=r1.GetTempTt();
    CRectRef rect2;
    while(r2.Fetch()){
      if(IdenticalValues(r1,r2)){
	rect2=r2.GetTempTt();	
	if(Overlap(*rect1,*rect2)){
	  Associate(pRects,rect2);
	}
      }
    }
    CSetRef res = Difference(*rect1, pRects);
    pRects->Erase();
    StrictForEachAssociate(CRectangle, result, res){
      r1.SetTempTt(result);
      c3.Execute();
    }
    res->Erase();
  }
  return tempName;
}

CString Difference_bitemp(CSession * pSession, const CString & q1, const CString & q2){
  //////////////////////////////
  // Parse the queries
  CCursor c1(pSession,q1);
  CCursor c2(pSession,q2);

  //////////////////////////////
  // Construct a table for the result
  CString tempName=CreateTempTableFrom(pSession, q1);  
  Ref<CRectSet> pRects = new CRectSet;

  CRow r1(&c1);
  CRow r2(&c2);
  CCursor c3(pSession,tempName, &r1);

  c1.Execute();
  while(r1.Fetch()){
    c2.Execute();
    CRectRef rect1=r1.GetBitemp();
    CRectRef rect2;
    while(r2.Fetch()){
      if(IdenticalValues(r1,r2)){
	rect2=r2.GetBitemp();	
	if(Overlap(*rect1,*rect2)){
	  Associate(pRects,rect2);
	}
      }
    }
    CSetRef res = Difference(*rect1, pRects);
    pRects->Erase();
    StrictForEachAssociate(CRectangle, result, res){
      r1.SetBitemp(result);
      c3.Execute();
    }
    res->Erase();
  }
  return tempName;
}
