#include <stdio.h>
#include "core.h"
#include "mod.h"
#include "db.h"
#include "lib.h"

//////////////////////////////////////////////////
// Constructor/destructor

int InitModules(){
  return true;
}

void CloseModules(){  
}

//////////////////////////////
// Temporary tables
CString CreateTempTableFrom(CSession * pSession, CString aQuery){
  int n;
  char buffer[20];
  int retry=0;

  CString tempName;

  for(;;){
    n=GetTempNum(pSession);
    sprintf(buffer,"TMP$%d",n);
    tempName=buffer;    
    try{
      CCursor d(pSession,"CREATE TABLE "+tempName+" AS (SELECT * FROM ("+
		aQuery+") WHERE 1=0)");
      d.Execute();
      return tempName;
    }catch(CException e){
      // A table already exists (my guess anyway)
    }     
    try{
      CCursor c(pSession,"DROP TABLE "+tempName);
      c.Execute();
      // We managed to free a temporaty table.... use it
      CCursor d(pSession,"CREATE TABLE "+tempName+" AS (SELECT * FROM ("+
		aQuery+") WHERE 1=0)");
      d.Execute();
      return tempName;
    }catch(CException e){
      // unable to delete table
      // probably used by other process
      printf("Temporary table '%s' in use, retrying.\n", buffer);
      retry++;
    }
    VERIFY_MSG(retry<10,"Retried 10 times to allocate a temporary table, giving up.");
  }
}

//////////////////////////////
// Table numbering
static int lastTempNum=0;

int GetTempNum(CSession * pSession){
  // numbering
  lastTempNum++;
  if(lastTempNum>5) lastTempNum=0;
  return lastTempNum;
}  


//////////////////////////////
// Sysdate
void GetSysDate(CSession * pSession)
{
  CString aTimeQuery = "SELECT SYSDATE VT$$S, SYSDATE VT$$E FROM DUAL";  
  CCursor c(pSession,aTimeQuery);
  ASSERT(c.HasVt());
  c.Execute();
  CRow r(&c);
  VERIFY(r.Fetch());
  g_tNow = r.VtStart();
}  
