#ifndef _CTime_H_
#define _CTime_H_

// This is the flexible part...
#define TIME_SIZE 30


class CTime;
extern CTime g_tNow;

class CTime {
private:
  char m_tValue[TIME_SIZE];
  bool m_bNow;
  bool m_bInitialized;
public:
  // Contruct CTime objects
  CTime();
  CTime(char * pValue, bool now=false);
  
  // Retrieve information
  bool IsNow() const;
  
  // Methods
  friend bool operator < (const CTime & t1, const CTime & t2);
  friend bool operator > (const CTime & t1, const CTime & t2);
  friend bool operator == (const CTime & t1, const CTime & t2);
  
  inline const CTime & MostSig(const CTime & t1, const CTime & t2);
  inline CTime & MostSig(CTime & t1, CTime & t2);
  
  inline const CTime & Max(const CTime & t1, const CTime & t2);
  inline CTime & Max(CTime & t1, CTime & t2);
  
  const char * AsString() const { 
    if(m_bNow) return g_tNow.m_tValue; 
    else return m_tValue; }
  bool IsPointLater(const CTime & t) const;
};

bool operator < (const CTime & t1, const CTime & t2);
bool operator > (const CTime & t1, const CTime & t2);
bool operator == (const CTime & t1, const CTime & t2);
CTime & MostSig(CTime & t1, CTime & t2);
CTime Max(CTime t1, CTime t2);
CTime Min(CTime & t1, CTime & t2);

inline bool operator <= (const CTime & t1, const CTime & t2) 
{ return !(t1>t2); }
inline bool operator >= (const CTime & t1, const CTime & t2) 
{ return !(t1<t2); }

const CTime END_OF_TIME      ("9999/12/31~23:59:58");
const CTime BEGINNING_OF_TIME("0000/01/01~00:00:00");

#endif //_CTime_H_
