//
// Time.cpp
//
// by Thomas Rask Thomsen.
//
//
// Various operations on time.
// Read and write time from strings
//   1998/01/30~00:57:48-1998/01/30~00:57:48
// Add and subtract seconds, minutes, hours, days, 
// months, and years.
//

#include <stdio.h>
#include "mod_timecalc.h"

void StrToTime(TimeRecord & t, const char * s){
  sscanf(s,"%d/%d/%d~%d:%d:%d", 
	 &t.year, &t.month, &t.day, &t.hour, &t.minute, &t.second);
}

void TimeToStr(const TimeRecord & t, char * s){
  sprintf(s,"%.4d/%.2d/%.2d~%.2d:%.2d:%.2d", 
	  t.year, t.month, t.day, t.hour, t.minute, t.second);
}

int DaysOfMonth(int year, int mounth){
  int m=(12*year+mounth-1) % 12+1;
  int y=(12*year+mounth-1) / 12;

  int days;
  switch(m){
  case 4: 
  case 6: 
  case 9: 
  case 11:
    days=30;
    break;    
  case 2:
    if(y%1000==0){
      days=29;
    } else if(y%100==0){
      days=28;
    } else if(y%4==0){
      days=29;
    } else {
      days=28;
    }
    break;
  default:
    days=31;
  }
  return days;
}

void AddYear(TimeRecord & t, const int i){
  t.year+=i;
}

void AddMonth(TimeRecord & t, const int i){
  int q=12*t.year+t.month+i;
  t.month = ( (q-1) % 12 + 1);
  t.year  = ( (q-1) / 12);
}

void AddDay(TimeRecord & t, const int i){
  int m,r;
  if(i<0){
    m=-i; r=-1;
  } else {
    m=i;  r=1;
  }  
  for(int j=0;j<m;j++){
    t.day+=r;
    int days=DaysOfMonth(t.year,t.month);
    if(t.day>days){
      t.day=1;
      AddMonth(t,1);
    } else if(t.day==0){
      t.day=DaysOfMonth(t.year,t.month-1);
      AddMonth(t,-1);
    }
  }
}

void AddHour(TimeRecord & t, const int i){
  int h,d;
  int H=t.hour+i;  
  if(H>=0){
    h=H % 24;
    d=H / 24;
  } else {
    h=H % 24 + 24;    
    d=H / 24 -  1;
  }
  t.hour=h;
  if(d!=0) AddDay(t,d);
}

void AddMinute(TimeRecord & t, const int i){
  int m,h;
  int M=t.minute+i;  
  if(M>=0){
    m=M % 60;
    h=M / 60;
  } else {
    m=M % 60 + 60;    
    h=M / 60 -  1;
  }
  t.minute=m;
  if(h!=0) AddHour(t,h);
}

void AddSecond(TimeRecord & t, const int i){
  int s,m;
  int S=t.second+i;  
  if(S>=0){
    s=S % 60;
    m=S / 60;
  } else {
    s=S % 60 + 60;    
    m=S / 60 -  1;
  }
  t.second=s;
  if(m!=0)AddMinute(t,m);
}

