/*
 *
 * lib_timecalc.h
 *
 * by Thomas Rask Thomsen.
 *
 * Various operations on time.
 * Read and write time from strings
 *   1998/01/30~00:57:48
 * Add and subtract seconds, minutes, hours, days, 
 * months, and years.
 *
 * Comment: 
 *   Adding numerous days, months, and years are
 *   expensive operations in the current implementation.
 *
 */

#ifndef _TIMECALC_H_
#define _TIMECALC_H_

class TimeRecord{
public:
  int year;
  int month;
  int day;
  int hour;
  int minute;
  int second;
};

void StrToTime(TimeRecord & t, const char * s);
void TimeToStr(const TimeRecord & t, char * s);

int  DaysOfMonth(int year, int mounth);
/* In the following i may be any number, positive or negative. */
void AddYear(TimeRecord & t, const int i);
void AddMonth(TimeRecord & t, const int i);
/* The following are slow for large i */
void AddDay(TimeRecord & t, const int i); 
void AddHour(TimeRecord & t, const int i);
void AddMinute(TimeRecord & t, const int i);
void AddSecond(TimeRecord & t, const int i);

#endif
