#include <stdio.h>
#include <strings.h>
/*
 * interface.cc
 * 
 * This is the interface file between prolog (tiger) and C++.
 * Since prolog only understands ordinary C functions, every
 * function used by prolog is incaplulated in an 
 *    extern "C" { }
 * contruction in order to look like ordinary C from the 
 * outside; on the inside they are C++!!!...
 *
 * Thomas Rask Thomsen - Aalborg University 1997
 */

#include "db.h"
#include "lib.h"

extern "C"{
#include <SWI-Prolog.h>
#include <ociapr.h>

  
  extern Lda_Def *lda; 	/* database workspace */  
  
  //////////////////////////////////////////////////////////////////////
  // COALESCING
  
  //////////
  // temp vt 
  
  // open the database
  // (reuse lda from swi_ora.c)
  
  foreign_t pl_coal_temp_vt(term_t que, term_t res){
    CSession aSession;
    aSession.Open(lda);
    GetSysDate(&aSession);
    // get query
    char * str;
    PL_get_list_chars(que,&str,BUF_DISCARDABLE);
    CString theQuery = str;
    // calculate
    CString theResult = Coal_temp_vt(&aSession, theQuery);
    // return result
    PL_unify_list_chars(res, theResult);
    PL_succeed;
  }
  
  //////////
  // temp tt
  foreign_t pl_coal_temp_tt(term_t que, term_t res){
    CSession aSession;
    aSession.Open(lda);
    GetSysDate(&aSession);
    // get query
    char * str;
    PL_get_list_chars(que,&str,BUF_DISCARDABLE);
    CString theQuery = str;
    // calculate
    CString theResult = Coal_temp_tt(&aSession, theQuery);
    // return result
    PL_unify_list_chars(res, theResult);
    PL_succeed;
  }
  
  //////////
  // bitemp vt
  foreign_t pl_coal_bitemp_vt(term_t que, term_t res){
    CSession aSession;
    aSession.Open(lda);
    GetSysDate(&aSession);
    // get query
    char * str;
    PL_get_list_chars(que,&str,BUF_DISCARDABLE);
    CString theQuery = str;
    // calculate
    CString theResult = Coal_bitemp_vt(&aSession, theQuery);
    // return result
    PL_unify_list_chars(res, theResult);
    PL_succeed;
  }
  
  //////////
  // bitemp tt
  foreign_t pl_coal_bitemp_tt(term_t que, term_t res){
    CSession aSession;
    aSession.Open(lda);
    GetSysDate(&aSession);
    // get query
    char * str;
    PL_get_list_chars(que,&str,BUF_DISCARDABLE);
    CString theQuery = str;
    // calculate
    CString theResult = Coal_bitemp_tt(&aSession, theQuery);
    // return result
    PL_unify_list_chars(res, theResult);
    PL_succeed;
  }

  //////////////////////////////////////////////////////////////////////
  // DIFFERENCE
  
  //////////
  // temp vt
  foreign_t pl_diff_temp_vt(term_t q1, term_t q2, term_t res){
    CSession aSession;
    aSession.Open(lda);
    GetSysDate(&aSession);
    // get query
    char * str;
    PL_get_list_chars(q1,&str,BUF_DISCARDABLE);
    CString query1 = str;
    PL_get_list_chars(q2,&str,BUF_DISCARDABLE);
    CString query2 = str;
    // calculate
    CString theResult = Difference_temp_vt(&aSession, query1, query2);
    // return result
    PL_unify_list_chars(res, theResult);
    PL_succeed;
  }
  
  //////////
  // temp tt
  foreign_t pl_diff_temp_tt(term_t q1, term_t q2, term_t res){
    CSession aSession;
    aSession.Open(lda);
    GetSysDate(&aSession);
    // get query
    char * str;
    PL_get_list_chars(q1,&str,BUF_DISCARDABLE);
    CString query1 = str;
    PL_get_list_chars(q2,&str,BUF_DISCARDABLE);
    CString query2 = str;
    // calculate
    CString theResult = Difference_temp_tt(&aSession, query1, query2);
    // return result
    PL_unify_list_chars(res, theResult);
    PL_succeed;
  }

  //////////
  // bitemp
  foreign_t pl_diff_bitemp(term_t q1, term_t q2, term_t res){
    CSession aSession;
    aSession.Open(lda);
    GetSysDate(&aSession);
    // get query
    char * str;
    PL_get_list_chars(q1,&str,BUF_DISCARDABLE);
    CString query1 = str;
    PL_get_list_chars(q2,&str,BUF_DISCARDABLE);
    CString query2 = str;
    // calculate
    CString theResult = Difference_bitemp(&aSession, query1, query2);
    // return result
    PL_unify_list_chars(res, theResult);
    PL_succeed;
  }

  ///////////////////////
  // -- pl_agr_bi
  
  foreign_t pl_agr_bi(term_t q,term_t f, term_t g, term_t h ,term_t res){
    CSession aSession;
    char *str;
    aSession.Open(lda);
    GetSysDate(&aSession);
    
    PL_get_list_chars(q,&str,BUF_DISCARDABLE);
    CString query = str;

    PL_get_list_chars(f,&str,BUF_DISCARDABLE);
    CString func = str;

    PL_get_list_chars(g,&str,BUF_DISCARDABLE);
    CString  group = str;

    PL_get_list_chars(h,&str,BUF_DISCARDABLE);
    CString having = str; 
    CString theResult;
    if(strstr(func,"COUNT"))    
       theResult = Aggregate_bi_count(&aSession, query, group,having);
     
  PL_unify_list_chars(res, theResult);
  PL_succeed;
  }

  ///////////////////////
  //-- pl_set_verbose mode
   foreign_t pl_set_verbose(term_t q1){
    char *sp;
    PL_get_list_chars(q1, &sp,BUF_DISCARDABLE);
    if(sp[0] == 'Y')  CCursor::verbose = 1;
    else CCursor::verbose = 0;    
    PL_succeed;
  }//end of pl_set_verbose

  //////////////////////////////
  // INITIALIZATION
  foreign_t init_ora();
  
  foreign_t init_module() {
    if(!init_ora()) PL_fail;
    if(!InitModules()) PL_fail;
    PL_register_foreign("pl_coal_temp_vt",  2,(pl_function_t)pl_coal_temp_vt,0);
    PL_register_foreign("pl_coal_temp_tt",  2,(pl_function_t)pl_coal_temp_tt,0);
    PL_register_foreign("pl_coal_bitemp_vt",2,(pl_function_t)pl_coal_bitemp_vt,0);
    PL_register_foreign("pl_coal_bitemp_tt",2,(pl_function_t)pl_coal_bitemp_tt,0);
    PL_register_foreign("pl_diff_temp_vt",3,(pl_function_t)pl_diff_temp_vt,0);
    PL_register_foreign("pl_diff_temp_tt",3,(pl_function_t)pl_diff_temp_tt,0);
    PL_register_foreign("pl_diff_bitemp", 3,(pl_function_t)pl_diff_bitemp,0);
    PL_register_foreign("pl_set_verbose",1,(pl_function_t)pl_set_verbose,0);
    PL_register_foreign("pl_agr_bi",5,(pl_function_t)pl_agr_bi,0);
    PL_succeed;
  }
}
