:- module(cross,[cross/1]).

%% This list may have to be adapted  %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- dynamic mods/1.
:- dynamic defs/3.
:- dynamic uses/3.

defs('lists.pl',member,2).
defs('lists.pl',append,3).
defs('lists.pl',memberchk,2).
defs('lists.pl',sum_list,2).
defs('lists.pl',max_list,2).
defs('lists.pl',select,3).
defs('lists.pl',is_list,1).
defs('lists.pl',substitute,4).
defs('lists.pl',delete,3).
defs('lists.pl',nth0,3).

defs('swi_ora.c',ora_close_cursor,1).
defs('swi_ora.c',ora_open_db,1).
defs('swi_ora.c',ora_close_db,0).
defs('swi_ora.c',ora_commit,0).
defs('swi_ora.c',ora_rollback,0).
defs('swi_ora.c',ora_describe_column,3).
defs('swi_ora.c',ora_get_column,3).
defs('swi_ora.c',ora_fetch_row,1).
defs('swi_ora.c',ora_put_var,3).
defs('swi_ora.c',ora_open_cursor,1).
defs('swi_ora.c',ora_compile_statement,3).
defs('swi_ora.c',ora_exec_cursor,2).

defs('interface.cpp',pl_coal_temp_vt,2).
defs('interface.cpp',pl_coal_temp_tt,2).
defs('interface.cpp',pl_coal_bitemp_vt,2).
defs('interface.cpp',pl_coal_bitemp_tt,2).
defs('interface.cpp',pl_diff_temp_vt,3).
defs('interface.cpp',pl_diff_temp_tt,3).
defs('interface.cpp',pl_diff_bitemp,3).

defs('forky.c',forky_init,0).
defs('forky.c',tcldp_install,0).
defs('forky.c',create_process,3).

defs('time.c',get_system_time,7).

defs('c2sics.c',c2sics_init,0).

defs('gmlib.pl','=>',2).
defs('gmlib.pl','<=',2).
defs('gmlib.pl',waitevent,1).
defs('gmlib.pl',start,0).
defs('gmlib.pl',end,0).

defs('charsio.pl',format_to_chars,3).
defs('charsio.pl',format_to_chars,4).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

insert(F) :- F, !.
insert(F) :- assert(F).

pred_of(A,_) :- var(A), !, fail.
pred_of(ensure_loaded('$ORACLE_EMULATOR/oracle'),_) :- !, fail.
pred_of(unix(_),_) :- !, fail.
pred_of(load_foreign_library(_,_),_) :- !, fail.
pred_of(ensure_loaded([H|T]),_) :- !,
  member(X,[H|T]),
    atom_chars(X,Chars),
    append(Chars,".pl",NameChars),
    atom_chars(Name,NameChars),
    getit(Name),
    fail.
pred_of(ensure_loaded(X),_) :- 
  atom_chars(X,Chars),
  append(Chars,".pl",NameChars),
  atom_chars(Name,NameChars),
  getit(Name),
  fail.
pred_of((A->B;C),X) :- !, (pred_of(A,X); pred_of(B,X); pred_of(C,X)).
pred_of((A,B),X) :- !, (pred_of(A,X); pred_of(B,X)).
pred_of((A;B),X) :- !, (pred_of(A,X); pred_of(B,X)).
pred_of(set_of(_,A,_),X) :- X=set_of/3; pred_of(A,X).
pred_of(H,P/A) :- !, \+ predicate_property(H,built_in), functor(H,P,A).
%pred_of(assert(F),P/A) :- functor(F,P,A).
%pred_of(retract(F),P/A) :- functor(F,P,A).

pred_of_dcg(A,_) :- var(A), !, fail.
pred_of_dcg([],_) :- !, fail.
pred_of_dcg(!,_) :- !, fail.
pred_of_dcg([_|_],_) :- !, fail.
pred_of_dcg({A},X) :- !, pred_of(A,X).
pred_of_dcg((A,B),X) :- !, (pred_of_dcg(A,X); pred_of_dcg(B,X)).
pred_of_dcg((A;B),X) :- !, (pred_of_dcg(A,X); pred_of_dcg(B,X)).
pred_of_dcg(H,P/A) :- !, functor(H,P,A1), A is A1+2.

handle(_,(:-consult(R))) :- !,
  (var(R) ->
     true;
     atom_chars(R,Chars),
     append(Chars,".pl",NameChars),
     atom_chars(Name,NameChars),
     getit(Name)).
handle(_,(:-op(X,Y,Z))) :- !, op(X,Y,Z).
handle(_,end_of_file) :- !.
handle(M,_:Clause) :- !, handle(M,Clause).
handle(M,(H,_-->B)) :- !,
  functor(H,P,A1), A is A1+2,
  insert(defs(M,P,A)),
  (pred_of_dcg(B,Q/C),
     insert(uses(Q,C,M)),
     fail; true).
handle(M,(H-->B)) :- !,
  functor(H,P,A1), A is A1+2,
  insert(defs(M,P,A)),
  (pred_of_dcg(B,Q/C),
     insert(uses(Q,C,M)),
     fail; true).
handle(_,(:- dynamic F/A)) :- !,  insert(defs(dynamic,F,A)).
handle(M,(:-B)) :- !, 
  (pred_of(B,Q/C), 
     insert(uses(Q,C,M)),
     fail; true).
handle(M,(H:-B)) :- !, 
  functor(H,P,A), 
  insert(defs(M,P,A)),
  (pred_of(B,Q/C), 
     insert(uses(Q,C,M)),
     fail; true).
handle(M,H) :- !,
  functor(H,P,A), 
  insert(defs(M,P,A)).

getit(M) :-
  write('Reading '), write(M), nl, 
  assert(mods(M)),
  seeing(T),
  see(M),
  repeat,
    read(C),
    handle(M,C),
    C=end_of_file, !,
  seen, 
  see(T).

write_list([]).
write_list([X|Y]) :- 
  write(X), write_list(Y).

size_list([],0).
size_list([X|Y],N) :- 
  name(X,L), length(L,M), size_list(Y,J), N is M+J.

write_comment(L) :-
  write('/*!'), write_list(L), size_list(L,N), M is 75-N, tab(M), write('*/'),
  nl.

w_safe_export(P,A,[X1,X2,X3,X4,X5,X6,X7,X8|R]) :- !, 
  write_comment(['            ',P,'/',A,' (',X1,X2,X3,X4,X5,X6,X7,X8]),
  w_safe_export2(R).
w_safe_export(P,A,X) :-
  write_comment(['            ',P,'/',A,' ('|X]).

w_safe_export2([X1,X2,X3,X4,X5,X6,X7,X8|R]) :- !, 
  write_comment(['                                ',X1,X2,X3,X4,X5,X6,X7,X8]),
  w_safe_export2(R).
w_safe_export2(X) :-
  write_comment(['                                '|X]).

write_stars :-
  write('/*!****************************************************************************/'),
  nl.

prep_list([X],[X,')']).
prep_list([X|Y],[X,','|Z]) :- prep_list(Y,Z).

cross(R) :-
  (mods(M), retractall(defs(M,_,_)), fail; true),
  retractall(mods(_)),
  retractall(uses(_,_,_)),
  atom_chars(R,Chars),
  append(Chars,".pl",NameChars),
  atom_chars(Name,NameChars),
  getit(Name),
  (uses(P,A,M), \+ defs(_,P,A),
    write_list(['Warning: ',P,'/',A,' (',M,') not declared.']), nl, 
    fail; true),
  (mods(M),
    atom_chars(M,C), append(C,".crefs",D), atom_chars(O,D), tell(O),
    write_stars,
    write_comment([' File:      ',M]),
    write_comment([' Project:   Tiger']),
    write_comment([' Software:  SWI Prolog 2.7.16, Oracle 8.0.4']),
    write_comment([' Export:']),
    (defs(M,P,A), findall(N,(uses(P,A,N), N\==M),L), L\==[], prep_list(L,H),
       w_safe_export(P,A,H),
       fail; true),
    write_comment([' Import:']),
    (mods(N), defs(N,P,A), uses(P,A,M), M\==N,
       write_comment(['            ',P,'/',A,' (',N,')']),
       fail; true),
    write_stars,
    told,
    fail; true).
