/*!****************************************************************************/
/*! File:      eval.pl                                                        */
/*! Project:   Tiger                                                          */
/*! Software:  SWI Prolog 2.7.16, Oracle 8.0.4                                */
/*! Export:                                                                   */
/*!            e_insert/5 (interpret.pl)                                      */
/*!            e_delete/6 (interpret.pl)                                      */
/*!            e_update/7 (interpret.pl)                                      */
/*! Import:                                                                   */
/*!            m_table_type/3 (meta.pl)                                       */
/*!            m_sql_exec/5 (meta.pl)                                         */
/*!            t_trans_query/3 (trans.pl)                                     */
/*!            f_raise_err/2 (fejl.pl)                                        */
/*!            z_get_current/1 (zeit.pl)                                      */
/*!            z_inc_ts/3 (zeit.pl)                                           */
/*!****************************************************************************/

%% get_explicit_cols(+TableName, TableAlias, -ColumnNames, -SelectList)
%% returns lists with explicit column names and column references respectively
get_explicit_cols(TabName, TabAlias, ColNames, SelList) :- !,
  findall(ColName, m_get_col(TabName, ["VT$","TT$"], ColName, _), ColNames),
  findall(col_ref(TabAlias,CN,_), member(CN,ColNames), SelList).

/******************************************************************************/
/* Mode:	e_insert      						      */
/* Purpose:	insertion of tuples                                           */
/* Sideeffects: DB tables are modified                                        */
/* Call:        Exists always				                      */
/* Redo:        Fails always				      		      */
/******************************************************************************/

%% add_time_col_names(+TabName, +ColumnNames, -ColumnNames)
add_time_col_names(TabName, ColNames, ColNames1) :-
  m_table_type(TabName,[],TabType),
  (  TabType==vt
  -> ColNames1=["VT$$S","VT$$E"|ColNames]
  ;  TabType==tt
  -> ColNames1=["TT$$S","TT$$E"|ColNames]
  ;  TabType==bi
  -> ColNames1=["TT$$S","TT$$E","VT$$S","VT$$E"|ColNames]
  ;  ColNames1=ColNames
  ).

%% add_tuc(+QueryExpr, -QueryExpr1)
add_tuc(values(EL), values([period(Ts,now)|EL])) :-
  z_get_current(Ts).
add_tuc(sel(M,S,F,W,G,H), sel(M,[sel_col(period(Ts,now),nil)|S],F,W,G,H)) :-
  z_get_current(Ts).
add_tuc(union(A,B), union(A1,B1))   :- add_tuc(A, A1), add_tuc(B, B1).
add_tuc(except(A,B), except(A1,B1)) :- add_tuc(A, A1), add_tuc(B, B1).
add_tuc(isct(A,B), isct(A1,B1))     :- add_tuc(A, A1), add_tuc(B, B1).

%% e_insert(+TableName, +ColumnNames, +Flag, +NormalizedQueryExpr, -NumTuples)
e_insert(TabName, ColNames, flag(vt(VTM,VTD),tt(TTM,TTD),VTR), QExpr, NumTpls) :-
  (  ColNames==[]
  -> get_explicit_cols(TabName, _, ColNames1, _)
  ;  ColNames1=ColNames
  ),
  add_time_col_names(TabName, ColNames1, ColNames2),
  t_trans_query(query(flag(vt(VTM,VTD),tt(TTM,TTD),VTR),QExpr,nil+nil,[]), _,
              query(nil,QExpr1,nil,[])),
  (  memberchk("VT$$S",ColNames2), VTR == nil, VTM == tuc
  -> add_tuc(QExpr1, QExpr2)
  ;  QExpr2 = QExpr1
  ),
  (  memberchk("TT$$S",ColNames2)
  -> add_tuc(QExpr2, QExpr3)
  ;  QExpr3 = QExpr2
  ),
  m_sql_exec([], dml(nil,insert(TabName,ColNames2,QExpr3)), nil, dml, NumTpls).

/******************************************************************************/
/* Mode:        e_delete(+TabType, +TabName, +TabAlias, +Flag, +Where, -Flag) */
/* Purpose:	deletion of tuples                                            */
/* Sideeffects:                                                               */
/* Call:        Exists always				                      */
/* Redo:        Fails always				      		      */
/******************************************************************************/

%% e_delete(+TableType, +TableName, +TableAlias, +Flag, +Where, -NumTuples)
e_delete(tt, _, _, flag(_,tt(seq,_),nil), _, _) :- !,
  f_raise_err(not_implemented, "sequenced transaction time deletions").
e_delete(tt, TabName, TabAlias, flag(_,tt(TTM,TTD),nil), Where, NumTpls) :-
  z_get_current(Curr),
  t_trans_query(query(flag(vt(tuc,nil),tt(TTM,TTD),nil),
                    sel(all,[],[],Where,[],true),nil,[]),_,
              query(nil,sel(_,_,_,Where1,_,_),nil,[])),
  (  TTM==ns
  -> Where2=and(rel(eq,col_ref(nil,"TT$$E",ts),now),Where1)
  ;  Where2=Where1
  ),
  z_inc_ts(Curr,-1,Curr1),
  m_sql_exec([],dml(nil,update(TabName,TabAlias,
      set([col_ref(nil,"TT$$E",ts)],[Curr1]),Where1)), nil, dml, NumTpls).

/********************** vt table deletes **************************************/

e_delete(vt, _, _, flag(vt(seq,_),_,nil), _, _) :- !,
  f_raise_err(not_implemented, "sequenced valid time deletions").
e_delete(vt, TabN, TabA, flag(vt(tuc,_),_,_), Where, NumTpls) :- !,
  z_get_current(Curr),
  t_trans_query(query(flag(vt(tuc,nil),tt(tuc,nil),nil),
       sel(all,[],[tab_ref(TabN,nil,nil+nil)],Where,[],true),nil,[]),_,
              query(nil,sel(_,_,_,Where1,_,_),nil,[])),
  z_inc_ts(Curr,-1,Curr1),
  m_sql_exec([],dml(nil,update(TabN,TabA,
      set([col_ref(TabA,"VT$$E",ts)],[Curr1]),Where1)), nil, dml, NumTpls).
e_delete(vt, TabName, TabAlias, flag(vt(ns,nil),_,_), Where, NumTpls) :- !,
  m_sql_exec([],dml(nil,delete(TabName,TabAlias,Where)), nil, dml, NumTpls).

/********************** bi table deletes **************************************/

e_delete(bi, _, _, flag(vt(seq,_),_,nil), _, _) :- !,
  f_raise_err(not_implemented, "sequenced valid time deletions").
e_delete(bi, _, _, flag(_,tt(seq,_),nil), _, _) :- !,
  f_raise_err(not_implemented, "sequenced transaction time deletions").
e_delete(bi, TabN, TabA, flag(vt(tuc,nil),tt(TTM,nil),nil), W, NumTpls) :- !,
  z_get_current(Curr),
  t_trans_query(query(flag(vt(tuc,nil),tt(TTM,nil),nil),
       sel(all,[],[tab_ref(TabN,TabA,nil+nil)],W,[],true),nil,[]),_,
              query(nil,sel(_,_,_,Where1,_,_),nil,[])),
  (  TTM == ns
  -> Where2 = and(rel(eq,col_ref(nil,"TT$$E",ts),now),Where1)
  ;  Where2 = Where1
  ),
  get_explicit_cols(TabN, TabA, ColNames, SelCols),
  z_inc_ts(Curr,-1,Curr1),
  m_sql_exec([], dml(nil,
     insert(TabN,["TT$$S","TT$$E","VT$$S","VT$$E"|ColNames],
        sel(all,[period(Curr,now),period(begin(vtime(TabA)),Curr1)|SelCols],
            [tab_ref(TabN,TabA,nil)],Where2,[],true))),
           nil, dml, _),
  m_sql_exec([],
     dml(nil,update(TabN,TabA,set([col_ref(nil,"TT$$E",ts)],[Curr1]),Where2)),
     nil, dml, NumTpls).
e_delete(bi, TabN, TabA, flag(vt(ns,nil),tt(TTM,nil),nil), Where, NumTpls) :- !,
  z_get_current(Curr),
  t_trans_query(query(flag(vt(ns,nil),tt(TTM,nil),nil),
       sel(all,[],[tab_ref(TabN,TabA,nil+nil)],Where,[],true),nil,[]),_,
              query(nil,sel(_,_,_,Where1,_,_),nil,[])),
  (  TTM == ns
  -> Where2 = and(rel(eq,col_ref(nil,"TT$$E",ts),now),Where1)
  ;  Where2 = Where1
  ),
  z_inc_ts(Curr,-1,Curr1),
  m_sql_exec([],
     dml(nil,update(TabN,TabA,set([col_ref(nil,"TT$$E",ts)],[Curr1]),Where)),
     nil, dml, NumTpls).
e_delete(bi, _, _, _, _, _) :- !,
  f_raise_err(not_implemented, "domain specifications in temporal deletions").

/******************************************************************************/
/* Mode:        e_update(+TabType, +TabName, +TabAlias, +Flag, +Set, +Where,  */
/*                       -Flag)                                               */
/* Purpose:	updating tuples                                               */
/* Sideeffects:                                                               */
/* Call:        Exists always				                      */
/* Redo:        Fails always				      		      */
/******************************************************************************/

%% e_update(+TableType, +TableName, +TableAlias, +Flag, +Set, +Where, -NumTuples)
e_update(tt, _, _, flag(_,tt(seq,_),nil), _, _, _) :- !,
  f_raise_err(not_implemented, "sequenced transaction time updates").
e_update(tt, TabN, TabA, flag(_,tt(TTM,TTD),nil), set(EL1,EL2), Where, NumTpls) :-
  z_get_current(Curr),
  t_trans_query(query(flag(vt(tuc,nil),tt(TTM,TTD),nil),
                    sel(all,[],[tab_ref(TabN,TabA,nil+nil)],Where,[],true),nil,[]),_,
              query(nil,sel(_,_,_,Where1,_,_),nil,[])),
  (  TTM==ns
  -> Where2=and(rel(eq,col_ref(nil,"TT$$E",ts),now),Where1)
  ;  Where2=Where1
  ),
  get_explicit_cols(TabN, TabA, ColNs, SelCols),
  z_inc_ts(Curr,-1,Curr1),
  m_sql_exec([], dml(nil,
     insert(TabN,["TT$$S","TT$$E"|ColNs],
        sel(all,[period(begin(ttime(TabA)),Curr1)|SelCols],
            [tab_ref(TabN,TabA,nil)],Where2,[],true))),
           nil, dml, _),
  m_sql_exec([],dml(nil,update(TabN,TabA,
                  set([ttime(TabA)|EL1],[period(Curr,now)|EL2]),
                  Where1)), nil, dml, NumTpls).

/********************** vt table updates **************************************/

e_update(vt, _, _, flag(vt(seq,_),_,nil), _, _) :- !,
  f_raise_err(not_implemented, "sequenced valid time deletions").
e_update(vt, TabN, TabA, flag(vt(tuc,_),_,_), set(EL1,EL2), Where, NumTpls) :- !,
  z_get_current(Curr),
  t_trans_query(query(flag(vt(tuc,nil),tt(tuc,nil),nil),
       sel(all,[],[tab_ref(TabN,TabA,nil+nil)],Where,[],true),nil,[]),_,
              query(nil,sel(_,_,_,Where1,_,_),nil,[])),
  get_explicit_cols(TabN, TabA, ColNs, SelCols),
  z_inc_ts(Curr,-1,Curr1),
  m_sql_exec([], dml(nil,
     insert(TabN,["VT$$S","VT$$E"|ColNs],
        sel(all,[period(begin(vtime(TabA)),Curr1)|SelCols],
            [tab_ref(TabN,TabA,nil)],Where1,[],true))),
           nil, dml, _),
  m_sql_exec([],dml(nil,update(TabN,TabA,
     set([col_ref(nil,"VT$$S",ts)|EL1],[Curr|EL2]),Where1)), nil, dml, NumTpls).
e_update(vt, TabN, TabA, flag(vt(ns,nil),_,_), Set, Where, NumTpls) :- !,
  m_sql_exec([],dml(nil,update(TabN,TabA,Set,Where)), nil, dml, NumTpls).

/************************** bi table updates **********************************/

e_update(bi, _, _, flag(vt(seq,_),_,nil), _, _) :- !,
  f_raise_err(not_implemented, "sequenced valid time deletions").
e_update(bi, _, _, flag(_,tt(seq,_),nil), _, _) :- !,
  f_raise_err(not_implemented, "sequenced transaction time deletions").
e_update(bi, TabN, TabA, flag(vt(tuc,nil),tt(TTM,nil),nil), set(EL1,EL2), 
         Where, NumTpls) :- !,
  z_get_current(Curr),
  t_trans_query(query(flag(vt(tuc,nil),tt(TTM,nil),nil),
       sel(all,[],[tab_ref(TabN,TabA,nil+nil)],Where,[],true),nil,[]),_,
              query(nil,sel(_,_,_,Where1,_,_),nil,[])),
  (  TTM == ns
  -> Where2 = and(rel(eq,col_ref(nil,"TT$$E",ts),now),Where1)
  ;  Where2 = Where1
  ),
  get_explicit_cols(TabN, TabA, ColNames, SelCols),
  z_inc_ts(Curr,-1,Curr1),
  m_sql_exec([], dml(nil,
     insert(TabN,["TT$$S","TT$$E","VT$$S","VT$$E"|ColNames],
        sel(all,[period(begin(ttime(TabA)),Curr1),vtime(TabA)|SelCols],
            [tab_ref(TabN,TabA,nil)],Where2,[],true))),
           nil, dml, _),
  m_sql_exec([], dml(nil,
     insert(TabN,["TT$$S","TT$$E","VT$$S","VT$$E"|ColNames],
        sel(all,[period(Curr,now),period(begin(vtime(TabA)),Curr1)|SelCols],
            [tab_ref(TabN,TabA,nil)],Where2,[],true))),
           nil, dml, _),
  m_sql_exec([],dml(nil,update(TabN,TabA,
                  set([ttime(TabA),col_ref(TabA,"VT$$S",ts)|EL1],
                      [period(Curr,now),Curr|EL2]),
                  Where1)), nil, dml, NumTpls).
e_update(bi, TabN, TabA, flag(vt(ns,nil),tt(TTM,nil),nil), set(EL1,EL2), 
         Where, NumTpls) :- !,
  z_get_current(Curr),
  t_trans_query(query(flag(vt(ns,nil),tt(TTM,nil),nil),
       sel(all,[],[tab_ref(TabN,TabA,nil+nil)],Where,[],true),nil,[]),_,
              query(nil,sel(_,_,_,Where1,_,_),nil,[])),
  (  TTM == ns
  -> Where2 = and(rel(eq,col_ref(nil,"TT$$E",ts),now),Where1)
  ;  Where2 = Where1
  ),
  get_explicit_cols(TabN, TabA, ColNames, SelCols),
  Curr1=Curr, /* !!! must be Curr1=Curr-1granule */
  m_sql_exec([], dml(nil,
     insert(TabN,["TT$$S","TT$$E","VT$$S","VT$$E"|ColNames],
        sel(all,[period(begin(ttime(TabA)),Curr1),vtime(TabA)|SelCols],
            [tab_ref(TabN,TabA,nil)],Where2,[],true))),
           nil, dml, _),
  m_sql_exec([],dml(nil,update(TabN,TabA,
                  set([ttime(TabA)|EL1],[period(Curr,now)|EL2]),
                  Where1)), nil, dml, NumTpls).
e_update(bi, _, _, _, _, _) :- !,
  f_raise_err(not_implemented, "domain specifications in temporal deletions").

