/*!****************************************************************************/
/*! File:      tiger.pl                                                       */
/*! Project:   Tiger                                                          */
/*! Software:  SWI Prolog 2.7.16, Oracle 8.0.4                                */
/*! Export:                                                                   */
/*!            check_option/1 (interpret.pl,scanner.pl)                       */
/*!            bf/3 (unparser.pl)                                             */
/*!            set_of/3 (interpret.pl,deps.pl,constraint.pl)                  */
/*!            nls_period_seperator/2 (unparser.pl,zeit.pl)                   */
/*! Import:                                                                   */
/*!            atsql/0 (interpret.pl)                                         */
/*!            z_p_ts/2 (zeit.pl)                                             */
/*!****************************************************************************/

:- dynamic db_is_open/0.
   /*      ************
      indicates whether a database is open or not
   */

:- dynamic tiger_flag/0.
   /*      ************
    signals a statement to be handled by Tiger; set during parsing
   */

:- dynamic error/2.
   /*      *******
      1: error id
      2: additional error arguments (error id specific)
   */

:- dynamic cursor/1.
   /*      ********
      handlers to open DB cursors
   */

:- dynamic verbose/0.
   /*      *********
      set if verbose mode is active
   */

:- dynamic inconsistent/0.
   /*      **************
      set by check_db if a constraint is violated
   */

:- dynamic nls_period_sep/2.
   /*      *****************
      character that separates start and end point in a period string.
      represented as character (1st argument) and atom (2nd argument).
   */

:- dynamic terminal_ctrl/2.
   /*      ***************
      1: column separator (list of ascii codes)
      2: row separator (list of ascii codes)
   */

:- dynamic transaction_status/3.
   /*      ********************
      1: MRS   (modified relation set, i.e. all relations that have
                been changed during the transaction)
      2: LCT   (last commit time)
      3: CKeys (keys of inserted integrity constraints)
   */
 
:- dynamic sysdate/1. 
   /*      *********
      1: current time as a constant of the form cst(Y/M/D/H/Min/S,ts)
         (for the purpose of running reproducible test files)   
   */

:- dynamic candidate_action/2.
   /*      ******************
      1: action (drop, insert, delete, update, rename)
      2: table/view name
   */

:- dynamic cols/2.
   /*      ******
      1: table name
      2: ordered information about columns: [ ColName-ColType, ... ]
   */

/******************************* debugging ************************************/

print_flags :-
  (clause(db_is_open, true), format("db_is_open = TRUE~n",[]), fail; true),
  (clause(tiger_flag, true),  format("tiger_flag = TRUE",[]), fail; true),
  (clause(error(A,B), true),
     format("error '~w' with args '~w'~n",[A,B]), fail; true),
  (clause(cursor(A), true), format("cursor = '~w'~n",[A]), fail; true),
  (clause(verbose, true), format("verbose is on~n",[]), fail; true),
  (clause(inconsistent, true), format("DB is inconsistent~n",[]), fail; true),
  (clause(nls_period_sep(C,A), true),
     format("period separator = 'char:~w atom:~w'~n",[C,A]), fail; true),
  (clause(transaction_status(A,B,C), true),
     findall(Y,(member(X,A),name(Y,X)),D),
     format("transac status:~n  XMRS = '~w'~n  LCT = '~w'~n  new ICs = '~w'~n",
            [D,B,C]), fail; true),
  (clause(sysdate(A), true), format("sysdate = '~w'~n",[A]), fail; true),
  (clause(candidate_action(A,B), true),
     format("action = '~w' on relation '~s'~n",[A,B]), fail; true),
  (clause(cols(A,B), true),
     findall(X1-Y,(member(X-Y,B),name(X1,X)),D),
     format("cols for '~s': ~w~n",[A,D]), fail; nl).

/****************************** SWI-Prolog ************************************/

check_option(O) :- unix(argv(A)), nth0(X,A,'--'), nth0(Y,A,O), X<Y.

get_seps(X,N,[A|R]) :- nth0(N,X,A), integer(A), !, N1 is N+1, get_seps(X,N1,R).
get_seps(_,_,[]).

sum_list(L,S) :- sum_list2(L,0,S).
sum_list2([],S,S).
sum_list2([H|T],S0,S) :- S1 is H+S0, sum_list2(T,S1,S).

max_list([H|T],M) :- max_list2(T,H,M).
max_list2([],M,M).
max_list2([H|T],X,M) :- H=<X, !, max_list2(T,X,M).
max_list2([H|T],_,M) :- max_list2(T,H,M).

min_list([H|T],M) :- min_list2(T,H,M).
min_list2([],M,M).
min_list2([H|T],X,M) :- H>=X, !, min_list2(T,X,M).
min_list2([H|T],_,M) :- min_list2(T,H,M).

format_to_chars(F,A,L) :- sformat(S,F,A), string_to_list(S,L).
format_to_chars(F,A,L,R) :- sformat(S,F,A), string_to_list(S,X), append(X,R,L).

bf(X,I,O) :- append(X,O,I).

:- redefine_system_predicate(select(_,_,_)).
select(X,L,L1) :- system:select(L,X,L1).

set_of(X,G,R) :- setof(X,G,R), !.
set_of(_,_,[]).

/******************************************************************************/

:- ensure_loaded([interpret,
                  scanner,
                  parser,
                  unparser,
                  rewrite,
                  meta,
                  views,
                  deps,
                  eval,
                  trans,
                  constraint,
                  fejl,
                  zeit]).

:- load_foreign_library(module, init_module).

:- unix(argv(X)), 
   (  nth0(N,X,'-csep')
   -> N1 is N+1, get_seps(X,N1,CSep)
   ;  CSep=[32,32]
   ),
   (  nth0(M,X,'-rsep')
   -> M1 is M+1, get_seps(X,M1,RSep)
   ;  RSep=[10]
   ),
   assert(terminal_ctrl(CSep,RSep)),
   (  nth0(O,X,'-sysdate')
   -> O1 is O+1,
      nth0(O1,X,A),
      atom_chars(A,Str),
      z_p_ts(str(Str),T),
      assert(sysdate(T))
   ; true
   ).

nls_period_sep(0'-,'-').

start :- see(user), atsql, halt.

