/*!****************************************************************************/
/*! File:      views.pl                                                       */
/*! Project:   Tiger                                                          */
/*! Software:  SWI Prolog 2.7.16, Oracle 8.0.4                                */
/*! Export:                                                                   */
/*!            v_uc2tuc/1 (interpret.pl)                                      */
/*! Import:                                                                   */
/*!            s_scan/2 (scanner.pl)                                          */
/*!            p_parse/2 (parser.pl)                                          */
/*!            r_norm_query_expr/3 (rewrite.pl)                               */
/*!            m_sql_exec/5 (meta.pl)                                         */
/*!            t_trans_query/3 (trans.pl)                                     */
/*!****************************************************************************/

/******************************************************************************/
/* Mode:	v_uc2tuc(+TableName)                                          */
/* Purpose:	migrates views that (in)directly depend on 'TableName'        */
/* Example:                                                                   */
/* Sideeffects:	DB is modified (TDB$VIEWS, Oracle views)                      */
/* Call:	exits always						      */
/* Redo:	fails always						      */
/******************************************************************************/

%% v_uc2tuc(+TableName)
%% migrates views that are directly derived from table 'TabName'
v_uc2tuc(TabN) :-
  m_sql_exec([var(TabN,s(_))],
    lit("SELECT T.NAME FROM USER_DEPENDENCIES T \
         WHERE T.REFERENCED_NAME=:1 AND T.TYPE='VIEW'"), nil, query, [ViewN]),
    (  m_sql_exec([var(ViewN,s(_))],
                lit("SELECT T.ATSQL_QUERY FROM TDB$VIEWS T WHERE T.NAME=:1"),
                nil, query, [ViewText])
     -> true;
        m_sql_exec([var(ViewN,s(_))],
                 lit("SELECT T.TEXT FROM USER_VIEWS T WHERE T.VIEW_NAME=:1"),
                 nil, query, [ViewText]),
        m_sql_exec([var(ViewN,s(_)),var(ViewText,s(l))],
                 lit("INSERT INTO TDB$VIEWS VALUES (:1, :2)"), nil, dml, _)
    ),
    m_sql_exec([],dml(nil,insert("TDB$DEPS",nil,
                    values([cst(ViewN,s(32)),cst("VIEW",s(32)),cst(TabN,s(32)),
                            cst("N",s(1)),cst("Y",s(1))]))),
             nil, _, _),
    s_scan(ViewText, Tokens),
    p_parse(Tokens, query(Flag,QExpr,_,_)),
    r_norm_query_expr(QExpr, Flag, QExpr1),
    t_trans_query(query(Flag,QExpr1,nil,[]), _, query(_,QExpr2,_,_)),
    findall(ColN, m_get_col(ViewN,[],ColN,_), ColNs),
    (  once(retract(sysdate(X)))
    -> m_sql_exec([], create_view(ViewN,ColNs,nil,QExpr2,nil), nil, other, _),
       assert(sysdate(X))
    ;  m_sql_exec([], create_view(ViewN,ColNs,nil,QExpr2,nil), nil, other, _)
    ),
    fail.
v_uc2tuc(_).

