/******************************************************************************/
/* Module:      flags.pl                                                      */
/* Project:     Oracle Emulator                                               */
/* Author:      Michael Boehlen                                               */
/* Language:    SWI Prolog 2.1.9                                              */
/* Machine:     SPARC/Solaris                                                 */
/* Export:                                                                    */
/* Import:                                                                    */
/******************************************************************************/

:- dynamic err/1.
   /*      *****
      1: ErrCode (an atom carrying error information, see 'sqlmsg.pl')
   */

:- dynamic verbose/0.
   /*      *********
      set if verbose mode is active
   */

:- dynamic undo_log/1.
   /*      **********
      1: Cmd (ordered set of assert/retract cmds that must be executed 
              to undo a transaction)
   */

:- dynamic cursor/5.
   /*      ********
      1: Cur     (unique number that identifies a cursor)
      2: StmtStr (SQL-statement as entered by the user)
      3: Stmt    (compiled statement, i.e. a SQL-statement)
      4: Row     (current row or 'none')
      5: Res     (the result of the last execution of the cursor, i.e. a 
                  table of rows)
   */

/******************************************************************************/
/* .									      */
/******************************************************************************/
