/******************************************************************************/
/* Module:      metadb.pl                                                     */
/* Project:     Oracle Emulator                                               */
/* Author:      Michael Boehlen                                               */
/* Language:    SWI Prolog 2.1.9                                              */
/* Machine:     SPARC/Solaris                                                 */
/* Export:                                                                    */
/* Import:                                                                    */
/******************************************************************************/

:- module(db,[]).

:- dynamic user_catalog/2,
           user_tables/1,
           user_views/2,
           user_sequences/1,
           user_tab_columns/5,
	   dictionary/2,
           dict_columns/3,
           dual/1,
           dict/2,
           cat/2,
           tabs/1,
           cols/5,
           num_cols/2,
           sequence/4.

dual("X").

dict(X,Y) :- dictionary(X,Y).
cat(X,Y) :- user_catalog(X,Y).
tabs(X) :- user_tables(X).
cols(R,N,T,Null,P) :- user_tab_columns(R,N,T,Null,P).

user_catalog("dictionary","table").	user_catalog("dict_columns","table").
user_catalog("user_catalog","table").	user_catalog("user_tables","table").
user_catalog("user_views","table").	user_catalog("user_tab_columns","table").
user_catalog("dual","table").		user_catalog("user_sequences","table").
user_catalog("dict","view").		user_catalog("cat","view").
user_catalog("tabs","view").		user_catalog("cols","view").

user_tables("dual").			user_tables("dictionary").
user_tables("dict_columns").		user_tables("user_catalog").
user_tables("user_tables").		user_tables("user_views").
user_tables("user_tab_columns").

user_tab_columns("dual","dummy","char","null",1).
user_tab_columns("dictionary","table_name","char","null",1).
user_tab_columns("dictionary","comments","char","null",2).
user_tab_columns("dict","table_name","char","null",1).
user_tab_columns("dict","comments","char","null",2).
user_tab_columns("dict_columns","table_name","char","null",1).
user_tab_columns("dict_columns","column_name","char","null",2).
user_tab_columns("dict_columns","comments","char","null",3).
user_tab_columns("user_catalog","table_name","char","not_null",1).
user_tab_columns("user_catalog","table_type","char","null",2).
user_tab_columns("cat","table_name","char","not_null",1).
user_tab_columns("cat","table_type","char","null",2).
user_tab_columns("user_tables","table_name","char","not_null",1).
user_tab_columns("tabs","table_name","char","not_null",1).
user_tab_columns("user_views","view_name","char","not_null",1).
user_tab_columns("user_views","text","char","null",2).
user_tab_columns("user_tab_columns","table_name","char","not_null",1).
user_tab_columns("user_tab_columns","column_name","char","not_null",2).
user_tab_columns("user_tab_columns","data_type","char","null",3).
user_tab_columns("user_tab_columns","nullable","char","null",4).
user_tab_columns("user_tab_columns","column_id","num","not_null",5).
user_tab_columns("cols","table_name","char","not_null",1).
user_tab_columns("cols","column_name","char","not_null",2).
user_tab_columns("cols","data_type","char","null",3).
user_tab_columns("cols","nullable","char","null",4).
user_tab_columns("cols","column_id","num","not_null",5).
user_tab_columns("user_sequences","sequence_name","char","not_null",1).

dictionary("cat","Synonym for USER_CATALOG").
dictionary("cols","Synonym for USER_TAB_COLUMNS").
dictionary("dict","Synonym for DICTIONARY").
dictionary("dictionary","Description of data dictionary tables and views").
dictionary("dict_columns","Column description of DD-tables and DD-views").
dictionary("tabs","Synonym for USER_TABLES").
dictionary("user_catalog","User accessible Tables, Views, Synonyms, Sequences").
dictionary("user_tables","Description of the user`s own tables").
dictionary("user_tab_columns","Columns of user`s tables, views and clusters").
dictionary("user_views","Text of views owned by the user").

dict_columns("cat","table_name","Name of the object").
dict_columns("cat","table_type","Type of the object").
dict_columns("cols","column_id","Sequence number of the column as created").
dict_columns("cols","column_name","Column name").
dict_columns("cols","data_type","Datatype of the column").
dict_columns("cols","nullable","Does column allow NULL values?").
dict_columns("cols","table_name","Table, view or cluster name").
dict_columns("dict","comments","Text comment on the object").
dict_columns("dict","table_name","Name of the object").
dict_columns("dictionary","comments","Text comment on the object").
dict_columns("dictionary","table_name","Name of the object").
dict_columns("dict_columns","column_name","Name of the column").
dict_columns("dict_columns","comments","Text comment on the object").
dict_columns("dict_columns","table_name","Name of object containing the column").
dict_columns("tabs","table_name","Name of the table").
dict_columns("user_catalog","table_name","Name of the object").
dict_columns("user_catalog","table-type","Type of the object").
dict_columns("user_tables","table_name","Name of the table").
dict_columns("user_tab_columns","column_id","Sequence number of the column").
dict_columns("user_tab_columns","column_name","Column name").
dict_columns("user_tab_columns","data_type","Datatype of the column").
dict_columns("user_tab_columns","nullable","Does column allow NULL values?").
dict_columns("user_tab_columns","table_name","Table, view or cluster name").
dict_columns("user_views","text","View text").
dict_columns("user_views","view_name","Name of the view").
dict_columns("user_sequences","sequence_name","Name of sequence").

num_cols("dictionary",2).	num_cols("dict_columns",3).
num_cols("user_tables",1).	num_cols("user_catalog",2).
num_cols("user_views",2).	num_cols("user_tab_columns",5).
num_cols("dict",2).		num_cols("cat",2).
num_cols("tabs",1).		num_cols("cols",5).
num_cols("dual",1).		num_cols("user_sequences",1).
num_cols("num_cols",2).		num_cols("sequence",4).

/******************************************************************************/
/* .									      */
/******************************************************************************/
