/******************************************************************************/
/* Module:      timeDB.pl                                                     */
/* Project:     TimeDB 1.07                                                   */
/* Author:      Andreas Steiner                                               */
/* Language:    SICStus Prolog                                                */
/* Machine:     SPARC/Solaris, PowerMac/MacOS                                 */
/* Export:                                                                    */
/* Import:                                                                    */
/*              check_option/1 (sicstus.pl)                                   */
/*              remove_counter/0 (basics.pl)                                  */
/*              drop_aux_tables/1 (basics.pl)                                 */
/*              parse/1 (parser.pl)                                           */
/*              print_error/0 (errors.pl)                                     */
/*              translate/3 (translate.pl)                                    */
/*              check_db_open/1 (check.pl)                                    */
/*              create_derived_tables/2 (evaluate.pl)                         */
/*              evaluate/4 (evaluate.pl)                                      */
/*              set_demo_tt/2 (time.pl)                                       */
/*              display_results/2 (display.pl)                                */
/******************************************************************************/

:- dynamic prolog/1.  		% Version of prolog: swi, sicstus
:- ensure_loaded([sicstus]).

:- ensure_loaded([basics]).
:- ensure_loaded([parser]).
:- ensure_loaded([errors]).
:- ensure_loaded([translate, evaluate, display]).
:- ensure_loaded([interface, meta_data]).
:- ensure_loaded([calendar]).

:- dynamic calendar/1.		% specifies which calendar is used
:- dynamic emulator/1.		% calculations done by emulator
:- dynamic oracle/1.		% calculations done by Oracle DBMS
:- dynamic demo/2.		% contains data for demo-system-time
:- dynamic tracing/1.		% tracing of query translation on/off
:- dynamic table_counter/1.	
:- dynamic alias_counter/1.
:- dynamic update_table/1.	% update of tt after commit, check constraints
:- dynamic check_table/1.  	% check constraints at commit
:- dynamic db_is_open/0.


intro :- 
	nl, write('{TimeDB 1.07, November 1, 1996}'), nl, 
	write('{Andreas Steiner, ETH Zuerich, Switzerland}'), nl, nl.
 
/****************************************************************************/
/* Mode:	atsql2      						    */
/* Purpose:	Interpreter-loop                                            */
/* Sideeffects:	Results or error messages are printed			    */
/* Call:        Exists always						    */
/* Redo:        Fails always				      		    */
/****************************************************************************/

interpret(quit) :- !.
interpret(ParseTree) :-
	check_db_open(ParseTree),
	!,
	translate(ParseTree, DerivedTables, SetOpStruct),
	(create_derived_tables(DerivedTables, DropTables1) ->
 	  (evaluate(SetOpStruct, ResType, ResultQuery, DropTables2),
	   display_results(ResType, ResultQuery),
	   drop_aux_tables(DropTables1), 
	   drop_aux_tables(DropTables2));
	  true),
	print_error,
	remove_counter.
interpret(_) :- 
	print_error.

atsql2 :-
        repeat,
          parse(ParseTree),
          interpret(ParseTree),
          ParseTree == quit.

:- assert(emulator(on)),
   assert(tracing(off)),
   nl,
   (prolog(swi), check_option('-w') ->
      true
      ;
      seeing(X), see(user), intro, atsql2, seen, see(X), nl, call(halt)).

