--Create delete trigger
CREATE TRIGGER Delete_PROJECTIONS 
AFTER DELETE ON PROJECTIONS 
REFERENCING OLD AS O FOR EACH ROW MODE DB2SQL 
BEGIN ATOMIC 
  INSERT INTO P_Audit VALUES (O.PROJECTION_ID, 
                              NULL,
                              NULL, 
                              NULL, 
                              NULL, 
                              NULL,
                              CURRENT TIMESTAMP,
                              'D'); 
END


--Create update trigger
CREATE TRIGGER Update_PROJECTIONS 
AFTER UPDATE ON PROJECTIONS
REFERENCING NEW AS N FOR EACH ROW MODE DB2SQL 
BEGIN ATOMIC 
INSERT INTO P_Audit VALUES (N.PROJECTION_ID, 
                            N.PROJECTION_NAME, 
                            N.PROJECTION_TYPE,
                            N.SPHEROID_CODE, 
                            N.PROJECTION_UOM, 
                            N.ZONE_CODE, 
                            CURRENT TIMESTAMP,
                            'U');
END

