-- Remove old triggers
DROP TRIGGER Insert_PROJECTIONS;
DROP TRIGGER Delete_PROJECTIONS;
DROP TRIGGER Update_PROJECTIONS;

--Create insert trigger
CREATE TRIGGER Insert_PROJECTIONS 
AFTER INSERT ON PROJECTIONS 
FOR EACH ROW 
BEGIN
  INSERT INTO P_Audit VALUES (:new.PROJECTION_ID, 
                              :new.PROJECTION_NAME,
                              :new.PROJECTION_TYPE, 
                              :new.SPHEROID_CODE, 
                              :new.PROJECTION_UOM, 
                              :new.ZONE_CODE,
                              SYSDATE,
                              'I'); 
END;
/

--Create delete trigger
CREATE TRIGGER Delete_PROJECTIONS 
AFTER DELETE ON PROJECTIONS 
FOR EACH ROW
BEGIN
  INSERT INTO P_Audit VALUES (:old.PROJECTION_ID, 
                              :old.PROJECTION_NAME,
                              :old.PROJECTION_TYPE, 
                              :old.SPHEROID_CODE, 
                              :old.PROJECTION_UOM, 
                              :old.ZONE_CODE,
                              SYSDATE,
                              'D'); 
END; 
/

--Create update trigger
CREATE TRIGGER Update_PROJECTIONS 
AFTER UPDATE ON PROJECTIONS
FOR EACH ROW
BEGIN
INSERT INTO P_Audit VALUES (:old.PROJECTION_ID, 
                            :old.PROJECTION_NAME, 
                            :old.PROJECTION_TYPE,
                            :old.SPHEROID_CODE, 
                            :old.PROJECTION_UOM, 
                            :old.ZONE_CODE, 
                            SYSDATE,
                            'U');
END;
/

