#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <dbi.h>
#include <stdio.h>


void SetupTables(void);
void CreateTriggers(void);
void PopulateTable(void);
void ClearTables(void); 
void OutputTables(void);
void Reconstruct(void);
void set_date(DB_OBJECT*);

main()
{

uci_startup ("reco1");

EXEC SQLX CONNECT 'AuditTrail';

	SetupTables();
	ClearTables(); 
	PopulateTable();
	Reconstruct();  
	OutputTables();

EXEC SQL DISCONNECT;
}


void SetupTables()
{
	EXEC SQLX CREATE TABLE PROJECTION (	PROJECTION_ID	INT,
											PROJECTION_NAME	INT,
											PROJECTION_TYPE	INT,
											SPHEROID_CODE	INT,
											PROJECTION_UOM	INT,
											ZONE_CODE	INT
											);

	EXEC SQLX CREATE TABLE P_Audit (	PROJECTION_ID	INT,
										PROJECTION_NAME	INT,
										PROJECTION_TYPE	INT,
										SPHEROID_CODE	INT,
										PROJECTION_UOM	INT,
										ZONE_CODE	INT ,
										When_Changed   DATE, 
										PRIMARY KEY  (PROJECTION_ID, When_Changed)
										);

	EXEC SQLX COMMIT WORK;

	EXEC SQLX ALTER CLASS P_Audit ADD METHOD set_date() FUNCTION set_date 
	FILE './reco1.o';

	EXEC SQLX COMMIT WORK;

}

void CreateTriggers(void)
{
	EXEC SQLX
		CREATE TRIGGER Delete_PROJECTIONS
		BEFORE DELETE ON PROJECTION
		EXECUTE
			INSERT INTO P_Audit VALUES(obj.PROJECTION_ID,obj.PROJECTION_NAME,obj.PROJECTION_TYPE,obj.SPHEROID_CODE,obj.PROJECTION_UOM,obj.ZONE_CODE,
			DATE '01/01/1800');
	EXEC SQLX COMMIT WORK;   
	
	EXEC SQLX
		CREATE TRIGGER Update_PROJECTIONS
		AFTER UPDATE ON PROJECTION 
		EXECUTE
			INSERT INTO P_Audit VALUES(old.PROJECTION_ID,
			old.PROJECTION_NAME,old.PROJECTION_TYPE,old.SPHEROID_CODE,old.PROJECTION_UOM,old.ZONE_CODE,DATE '01/01/1800'); 
			EXEC SQLX COMMIT WORK; 


	EXEC SQLX
		CREATE TRIGGER Insert_P_Audit
		AFTER INSERT ON P_Audit
		EXECUTE
			CALL set_date() on obj;

	EXEC SQLX COMMIT WORK;


}   

void set_date(DB_OBJECT *obj)
{
EXEC SQLX BEGIN DECLARE SECTION;
DB_VALUE d;
struct timeval  time_sec;
struct tm       *cur_time;
EXEC SQLX END DECLARE SECTION;

	gettimeofday(&time_sec, NULL);
	cur_time = localtime(&time_sec.tv_sec);

	db_make_date(&d,cur_time->tm_mon+1,cur_time->tm_mday,cur_time->tm_year+1900);
	db_put(obj,"When_Changed",&d);
	EXEC SQLX COMMIT WORK;
}


void ClearTables(void)
{
	EXEC SQL DELETE FROM PROJECTION;
	EXEC SQL DELETE FROM P_Audit;
	EXEC SQLX COMMIT WORK;
} 


void PopulateTable(void)
{
	CreateTriggers(); 

	EXEC SQL INSERT INTO PROJECTION VALUES (1, 1, 12, 1, 1, 1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL INSERT INTO PROJECTION VALUES (2, 1, 10, 1, 1, 1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL INSERT INTO PROJECTION VALUES (3, 1, 15, 1, 1, 1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL INSERT INTO PROJECTION VALUES (4, 1, 17, 1, 1, 1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL INSERT INTO PROJECTION VALUES (5, 1, 18, 1, 1, 1);
	EXEC SQLX COMMIT WORK;

	EXEC SQL DELETE FROM PROJECTION WHERE PROJECTION_ID = 5;
	EXEC SQLX COMMIT WORK;

	EXEC SQL UPDATE PROJECTION SET PROJECTION_TYPE = 13  WHERE  PROJECTION_ID = 2;
	EXEC SQLX COMMIT WORK;

	EXEC SQL UPDATE PROJECTION SET PROJECTION_TYPE = 11  WHERE  PROJECTION_ID = 3;
	EXEC SQLX COMMIT WORK;

	EXEC SQL UPDATE PROJECTION SET PROJECTION_TYPE = 14  WHERE  PROJECTION_ID = 2;
	EXEC SQLX COMMIT WORK;  


	EXEC SQL DELETE FROM PROJECTION WHERE PROJECTION_ID = 4;
	EXEC SQLX COMMIT WORK;

/* *************************************************************************
   The dates here have been changed so as to correspond with the table given 
   in the book.
   ************************************************************************* */

	EXEC SQL UPDATE P_Audit SET When_Changed = DATE '02/03/1996' WHERE
	PROJECTION_TYPE = 18;
	EXEC SQLX COMMIT WORK;

	EXEC SQL UPDATE P_Audit SET When_Changed = DATE '03/20/1996' WHERE
	PROJECTION_TYPE = 10;
	EXEC SQLX COMMIT WORK;

	EXEC SQL UPDATE P_Audit SET When_Changed = DATE '05/28/1996' WHERE
	PROJECTION_TYPE = 15;
	EXEC SQLX COMMIT WORK;

	EXEC SQL UPDATE P_Audit SET When_Changed = DATE '06/17/1996' WHERE
	PROJECTION_TYPE = 13;
	EXEC SQLX COMMIT WORK;

	EXEC SQL UPDATE P_Audit SET When_Changed = DATE '07/12/1996' WHERE
	PROJECTION_TYPE = 17;
	EXEC SQLX COMMIT WORK;

}


void Reconstruct(void)
{
EXEC SQLX BEGIN DECLARE SECTION;
int id;
int type;
int name;
EXEC SQLX END DECLARE SECTION;

EXEC SQLX DECLARE reconstruct CURSOR FOR
SELECT * 
FROM PROJECTION AS P
WHERE NOT EXISTS  (	SELECT *
			FROM P_Audit AS A
			WHERE P.PROJECTION_ID = A.PROJECTION_ID
				AND A.When_Changed > DATE '04/01/1996')
UNION
SELECT PROJECTION_ID, PROJECTION_NAME, PROJECTION_TYPE,
	SPHEROID_CODE, PROJECTION_UOM, ZONE_CODE
FROM P_Audit AS A
WHERE When_Changed  = (SELECT MIN (When_Changed)
			FROM P_Audit AS A2
			WHERE A.PROJECTION_ID = A2.PROJECTION_ID
				AND A2.When_Changed > DATE '04/01/1996');

EXEC SQLX OPEN reconstruct FOR READ ONLY;

fprintf(stdout, "-------------------\n");
fprintf(stdout, "Reconstructed table\n");
fprintf(stdout, "-------------------\n");
fprintf(stdout, "PROJECTION_ID   PROJECTION_TYPE\n", id, type, SQLERRMC);
fprintf(stdout, "--------------------------------\n");
for (;;)
{
	EXEC SQLX WHENEVER NOT FOUND GOTO not_fou;

	EXEC SQLX FETCH reconstruct INTO :id, :name ,:type;

	fprintf(stdout,"%d                  %d  %s\n", id, type, SQLERRMC);
}

not_fou :
	EXEC SQLX CLOSE reconstruct;

}


void OutputPROJECTION(void)
{
EXEC SQLX BEGIN DECLARE SECTION;
int id;
int type;
EXEC SQLX END DECLARE SECTION;

	/* 
		Output PROJECTION table
	*/
	EXEC SQLX DECLARE proj CURSOR FOR
		SELECT PROJECTION_ID, PROJECTION_TYPE
		FROM PROJECTION;
	
	EXEC SQLX OPEN proj FOR READ ONLY;

	fprintf(stdout,"------------------\n");
	fprintf(stdout, "PROJECTION table\n");
	fprintf(stdout,"-------------------\n");
	fprintf(stdout, "PROJECTION_ID  PROJECTION_TYPE\n", id, type, SQLERRMC);
	fprintf(stdout,"--------------------------------\n");
	for (;;)
	{
		EXEC SQLX WHENEVER NOT FOUND GOTO not_found;
		
		EXEC SQLX FETCH proj INTO :id, :type;
		
		fprintf(stdout, "%d                  %d  %s\n", id, type, SQLERRMC);
	}
	
not_found:
	EXEC SQLX CLOSE proj;
}


void OutputP_Audit(void)
{
EXEC SQLX BEGIN DECLARE SECTION;
int id;
int type;
DB_DATE ts;
char buf[20];
EXEC SQLX END DECLARE SECTION;

	/* 
		Output P_Audit table
	*/
	EXEC SQLX DECLARE p_aud CURSOR FOR
		SELECT PROJECTION_ID, PROJECTION_TYPE, When_Changed
		FROM P_Audit;
	
	EXEC SQLX OPEN p_aud FOR READ ONLY;
	
	fprintf(stdout, "--------------\n");
	fprintf(stdout, "P_Audit table\n");
	fprintf(stdout, "---------------\n");
	fprintf(stdout, "PROJECTION_ID  PROJECTION_TYPE  When_Changed\n", id, type, SQLERRMC);
	fprintf(stdout,"----------------------------------------------\n");
	for (;;)
	{
		EXEC SQLX WHENEVER NOT FOUND GOTO not_found;
		
		EXEC SQLX FETCH p_aud INTO :id, :type, :ts;
		db_date_to_string(buf,20,&ts);

		fprintf(stdout, "%d                  %d             %s\n", id, type,buf);
	}
	
not_found:
	EXEC SQLX CLOSE p_aud;
}


void OutputTables(void)
{
	OutputPROJECTION();
	OutputP_Audit();
	EXEC SQLX DROP TRIGGER Insert_P_Audit;
	EXEC SQLX COMMIT WORK;
	exit(0);
}
